/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.utils;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.jira.common.components.issues.JiraIssueLinkAccessor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class JiraSyncUtil {
    private final PortfolioExtensionLinkPersistence extensionLinkPersistence;

    public JiraSyncUtil(PortfolioExtensionLinkPersistence extensionLinkPersistence) {
        this.extensionLinkPersistence = extensionLinkPersistence;
    }

    public List<IExtensionLink> getIssueLinks(String workItemId) throws SQLException {
        ArrayList retVal = Lists.newArrayList();
        List<IExtensionLink> links = this.extensionLinkPersistence.getLinksForTarget(AOWorkItem.class, workItemId);
        if (links != null) {
            for (IExtensionLink link : links) {
                if (!link.getExtensionKey().startsWith("jira-issue")) continue;
                retVal.add(link);
            }
        }
        return retVal;
    }

    public List<IExtensionLink> getReleaseLinks(String release) throws SQLException {
        ArrayList retVal = Lists.newArrayList();
        List<IExtensionLink> links = this.extensionLinkPersistence.getLinksForTarget(AORelease.class, release);
        if (links != null) {
            for (IExtensionLink link : links) {
                retVal.add(link);
            }
        }
        return retVal;
    }

    public static String getIssueTitleForLink(IWorkItem item, IExtensionLink link, PortfolioStagePersistence stagePersistence) throws PersistenceException {
        String title = item.getTitle();
        if (title == null || title.trim().equals("")) {
            title = "No Summary";
        }
        if (WorkItems.Types.STORY.equals(item.getType())) {
            title = JiraSyncUtil.enrichIfStageLink(title, link, stagePersistence);
        }
        return title;
    }

    public List<IExtensionLink> getStageLinks(String workItemId) throws SQLException {
        ArrayList retVal = Lists.newArrayList();
        for (IExtensionLink link : this.getIssueLinks(workItemId)) {
            if (!JiraIssueLinkAccessor.isStageLink(link)) continue;
            retVal.add(link);
        }
        return retVal;
    }

    private static String enrichIfStageLink(String itemTitle, IExtensionLink link, PortfolioStagePersistence stagePersistence) throws PersistenceException {
        String stageId = JiraIssueLinkAccessor.getStageId(link);
        if (stageId == null) {
            return itemTitle;
        }
        IStage stage = (IStage)stagePersistence.get(stageId);
        return String.format("%s (%s)", itemTitle, stage.getTitle());
    }
}

