/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.Calendar;
import java.util.Date;
import net.objectlab.kit.datecalc.common.Utils;

public class WorkingWeek {
    private static final byte MONDAY = 1;
    private static final byte TUESDAY = 2;
    private static final byte WEDNESDAY = 4;
    private static final byte THURSDAY = 8;
    private static final byte FRIDAY = 16;
    private static final byte SATURDAY = 32;
    private static final byte SUNDAY = 64;
    private static final byte DEFAULT_WORKING_DAYS = 31;
    private static final byte[] WORKING_WEEK_DAYS_OFFSET = new byte[]{64, 1, 2, 4, 8, 16, 32};
    public static final WorkingWeek DEFAULT = new WorkingWeek();
    private byte workingDays = (byte)31;

    public WorkingWeek() {
        this(31);
    }

    protected WorkingWeek(byte workingDays) {
        this.workingDays = workingDays;
    }

    public boolean isWorkingDayFromCalendar(int dayOfWeek) {
        int day = this.adjustDay(dayOfWeek);
        return (WORKING_WEEK_DAYS_OFFSET[day] & this.workingDays) != 0;
    }

    public boolean isWorkingDay(Date date) {
        return this.isWorkingDay(Utils.getCal(date));
    }

    public boolean isWorkingDay(Calendar cal) {
        return this.isWorkingDayFromCalendar(cal.get(7));
    }

    protected int adjustDay(int dayOfWeek) {
        return dayOfWeek - 1;
    }

    public WorkingWeek withWorkingDayFromCalendar(boolean working, int dayOfWeek) {
        int day = this.adjustDay(dayOfWeek);
        WorkingWeek ret = this;
        if (working && !this.isWorkingDayFromCalendar(dayOfWeek)) {
            ret = new WorkingWeek((byte)(this.workingDays + WORKING_WEEK_DAYS_OFFSET[day]));
        } else if (!working && this.isWorkingDayFromCalendar(dayOfWeek)) {
            ret = new WorkingWeek((byte)(this.workingDays - WORKING_WEEK_DAYS_OFFSET[day]));
        }
        return ret;
    }

    public byte getWorkingDays() {
        return this.workingDays;
    }
}

