/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import java.util.ArrayList;
import java.util.List;
import net.objectlab.kit.datecalc.common.AbstractIMMDateCalculator;
import net.objectlab.kit.datecalc.common.IMMPeriod;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDateIMMDateCalculator
extends AbstractIMMDateCalculator<LocalDate> {
    protected static final int MONTHS_IN_QUARTER = 3;
    protected static final int MONTH_IN_YEAR = 12;
    protected static final int DAYS_IN_WEEK = 7;

    @Override
    public List<LocalDate> getIMMDates(LocalDate start, LocalDate end, IMMPeriod period) {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        LocalDate date = start;
        while (!(date = this.getNextIMMDate(true, date, period)).isAfter((ReadablePartial)end)) {
            dates.add(date);
        }
        return dates;
    }

    @Override
    protected LocalDate getNextIMMDate(boolean requestNextIMM, LocalDate start, IMMPeriod period) {
        LocalDate date = start;
        int month = date.getMonthOfYear();
        LocalDate imm = this.calculate3rdWednesday(date = this.calculateIMMMonth(requestNextIMM, date, month));
        int immMonth = imm.getMonthOfYear();
        boolean isMarchSept = immMonth == 3 || immMonth == 9;
        switch (period) {
            case BI_ANNUALY_JUN_DEC: {
                if (!isMarchSept) break;
                imm = this.getNextIMMDate(requestNextIMM, imm, period);
                break;
            }
            case BI_ANNUALY_MAR_SEP: {
                if (isMarchSept) break;
                imm = this.getNextIMMDate(requestNextIMM, imm, period);
                break;
            }
            case ANNUALLY: {
                imm = this.getNextIMMDate(requestNextIMM, imm, IMMPeriod.QUARTERLY);
                imm = this.getNextIMMDate(requestNextIMM, imm, IMMPeriod.QUARTERLY);
                imm = this.getNextIMMDate(requestNextIMM, imm, IMMPeriod.QUARTERLY);
                imm = this.getNextIMMDate(requestNextIMM, imm, IMMPeriod.QUARTERLY);
            }
        }
        return imm;
    }

    private LocalDate calculateIMMMonth(boolean requestNextIMM, LocalDate startDate, int month) {
        int monthOffset = 0;
        LocalDate date = startDate;
        switch (month) {
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                LocalDate immDate = this.calculate3rdWednesday(date);
                if (requestNextIMM && !date.isBefore((ReadablePartial)immDate)) {
                    date = date.plusMonths(3);
                    break;
                }
                if (requestNextIMM || date.isAfter((ReadablePartial)immDate)) break;
                date = date.minusMonths(3);
                break;
            }
            default: {
                if (requestNextIMM) {
                    monthOffset = (12 - month) % 3;
                    date = date.plusMonths(monthOffset);
                    break;
                }
                monthOffset = month % 3;
                date = date.minusMonths(monthOffset);
            }
        }
        return date;
    }

    private LocalDate calculate3rdWednesday(LocalDate original) {
        LocalDate firstOfMonth = original.withDayOfMonth(1);
        LocalDate firstWed = firstOfMonth.withDayOfWeek(3);
        if (firstWed.isBefore((ReadablePartial)firstOfMonth)) {
            firstWed = firstWed.plusWeeks(1);
        }
        return firstWed.plusWeeks(2);
    }

    @Override
    public boolean isIMMDate(LocalDate date) {
        boolean same = false;
        List<LocalDate> dates = this.getIMMDates(date.minusDays(1), date, IMMPeriod.QUARTERLY);
        if (!dates.isEmpty()) {
            same = date.equals((Object)dates.get(0));
        }
        return same;
    }
}

