/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemStatus;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AODependency;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.rest.entities.workitems.dependencies.RestDependencyWorkItem;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkItemDependencySQL
extends BaseAOPersistenceSQL {
    private static final String CHILDCOUNT = "CHILDCOUNT";
    private static final String OPENCHILDCOUNT = "OPENCHILDCOUNT";

    public WorkItemDependencySQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public Map<String, List<String>> getDependenciesForPlan(final String planId, final boolean includeDone) throws SQLException {
        return this.sql(new IQuery<Map<String, List<String>>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AODependency.class, "d").withTable(AOWorkItem.class, "wDent").withTable(AOWorkItem.class, "wDeee").select().col("d", "dependent").col("d", "dependee").from("d").leftJoin().table("wDent").on().col("d", "dependent").eq().colId("wDent").leftJoin().table("wDeee").on().col("d", "dependee").eq().colId("wDeee").where().col("wDent", "aoplan").eq().numeric(planId);
                if (!includeDone) {
                    generator.and().col("wDent", "status").neq().numeric(WorkItemStatus.COMPLETED.value()).and().col("wDeee", "aoplan").eq().numeric(planId);
                }
                if (!includeDone) {
                    generator.and().col("wDeee", "status").neq().numeric(WorkItemStatus.COMPLETED.value());
                }
            }

            @Override
            public Map<String, List<String>> handleResult(ResultSet result) throws Exception {
                HashMap retVal = Maps.newHashMap();
                while (result.next()) {
                    String dependent = BaseAOPersistenceSQL.getString(result, 1);
                    String dependee = BaseAOPersistenceSQL.getString(result, 2);
                    if (!retVal.containsKey(dependent)) {
                        retVal.put(dependent, Lists.newArrayList());
                    }
                    ((List)retVal.get(dependent)).add(dependee);
                }
                return retVal;
            }
        });
    }

    public void removeAllDependenciesForWorkItem(String id) throws SQLException {
        this.removeAllDependenciesForWorkItem(id, false);
    }

    private void removeAllDependenciesForWorkItem(final String id, final boolean dependentOnly) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AODependency.class, "d").deleteFrom().tableNoAlias("d").where().colNoAlias("d", "dependent").eq().numeric(id);
                if (!dependentOnly) {
                    generator.or().colNoAlias("d", "dependee").eq().numeric(id);
                }
            }
        });
    }

    public void setDependencies(String id, List<String> prerequisites) throws SQLException {
        this.removeAllDependenciesForWorkItem(id, true);
        if (prerequisites != null) {
            for (String dependee : prerequisites) {
                this.setDependency(id, dependee);
            }
        }
    }

    public void removeDependency(final String dependent, final String dependee) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AODependency.class, "d").deleteFrom().tableNoAlias("d").where().colNoAlias("d", "dependent").eq().numeric(dependent).and().colNoAlias("d", "dependee").eq().numeric(dependee);
            }
        });
    }

    public void setDependency(final String dependent, final String dependee) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AODependency.class, "d").insert().tableNoAlias("d").raw("(").colNoAlias("d", "dependent").colNoAlias("d", "dependee").raw(") VALUES (").numeric(dependent).raw(",").numeric(dependee).raw(")");
            }
        });
    }

    public List<RestDependencyWorkItem> getRequires(String workItemId, Boolean includeDone) throws SQLException {
        return this.getDependencies(workItemId, "dependee", "dependent", includeDone);
    }

    public List<RestDependencyWorkItem> getRequiredBy(String workItemId, Boolean includeDone) throws SQLException {
        return this.getDependencies(workItemId, "dependent", "dependee", includeDone);
    }

    private static void cleanupDependencies(List<RestDependencyWorkItem> workItems) {
        for (RestDependencyWorkItem workItem : workItems) {
            if (workItem.getChildren() == null) continue;
            WorkItemDependencySQL.cleanupDependencies(workItem.getChildren());
        }
        Iterables.removeIf(workItems, (Predicate)new Predicate<RestDependencyWorkItem>(){

            public boolean apply(RestDependencyWorkItem workItem) {
                return workItem.getRealDependency() == false && (workItem.getChildren() == null || workItem.getChildren().size() == 0);
            }
        });
    }

    private List<RestDependencyWorkItem> getDependencies(final String workItemId, final String columnJoin, final String columnClause, final Boolean includeDone) throws SQLException {
        final ArrayList hierarchies = Lists.newArrayList();
        for (int i = 0; i < 3; ++i) {
            hierarchies.add("w" + i);
        }
        return this.sql(new IQuery<List<RestDependencyWorkItem>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                int i;
                for (String hierarchy : hierarchies) {
                    generator.withTable(AOWorkItem.class, hierarchy).withTable(AOWorkItem.class, WorkItemDependencySQL.getHierarchyCounterAlias(hierarchy));
                }
                generator.withTable(AODependency.class, "d");
                generator.select();
                for (String hierarchy : hierarchies) {
                    WorkItemDependencySQL.addHierarchySelect(generator, hierarchy, columnJoin);
                }
                generator.from((String)hierarchies.get(0));
                for (int i2 = 1; i2 < hierarchies.size(); ++i2) {
                    WorkItemDependencySQL.addHierarchyJoin(generator, (String)hierarchies.get(i2), (String)hierarchies.get(i2 - 1));
                }
                for (String hierarchy : hierarchies) {
                    WorkItemDependencySQL.addChildCountJoin(generator, hierarchy);
                }
                generator.leftJoin().table("d").on().raw("(");
                for (i = 0; i < hierarchies.size(); ++i) {
                    if (i > 0) {
                        generator.or();
                    }
                    generator.col("d", columnJoin).eq().colId((String)hierarchies.get(i));
                }
                generator.raw(")");
                generator.where().col("d", columnClause).eq().numeric(workItemId).and().col((String)hierarchies.get(0), "aoParent").isNull();
                if (!includeDone.booleanValue()) {
                    generator.and().raw("(");
                    for (i = 0; i < hierarchies.size(); ++i) {
                        if (i > 0) {
                            generator.or();
                        }
                        generator.col((String)hierarchies.get(i), "status").neq().numeric(WorkItemStatus.COMPLETED.value());
                    }
                    generator.raw(")");
                }
            }

            @Override
            public List<RestDependencyWorkItem> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                HashMap idMap = Maps.newHashMap();
                while (result.next()) {
                    String parentId = null;
                    int index = 1;
                    for (int i = 0; i < hierarchies.size(); ++i) {
                        String id = BaseAOPersistenceSQL.getString(result, index++);
                        String title = BaseAOPersistenceSQL.getString(result, index++);
                        Integer type = WorkItemDependencySQL.getInteger(result, index++);
                        Integer itemStatus = WorkItemDependencySQL.getInteger(result, index++);
                        Boolean isRealDependency = BaseAOPersistenceSQL.getBoolean(result, index++);
                        Integer childCount = WorkItemDependencySQL.getInteger(result, index++);
                        Integer openChildCount = WorkItemDependencySQL.getInteger(result, index++);
                        if (id == null) continue;
                        Integer status = itemStatus;
                        if (childCount != null && childCount > 0 && (openChildCount == null || openChildCount == 0)) {
                            status = WorkItemStatus.COMPLETED.value();
                        }
                        RestDependencyWorkItem item = new RestDependencyWorkItem(id, title, type, childCount, isRealDependency, status);
                        if (!idMap.containsKey(id)) {
                            if (parentId == null) {
                                retVal.add(item);
                            } else {
                                ((RestDependencyWorkItem)idMap.get(parentId)).addChild(item);
                            }
                            idMap.put(id, item);
                        } else if (item.getRealDependency().booleanValue() && !((RestDependencyWorkItem)idMap.get(id)).getRealDependency().booleanValue()) {
                            ((RestDependencyWorkItem)idMap.get(id)).makeReal();
                        }
                        parentId = id;
                    }
                }
                WorkItemDependencySQL.cleanupDependencies(retVal);
                return retVal;
            }
        });
    }

    private static void addHierarchyJoin(AOQueryGenerator generator, String hierarchy, String parentHierarchy) {
        generator.leftJoin().table(hierarchy).on().col(hierarchy, "aoParent").eq().colId(parentHierarchy);
    }

    private static String getHierarchyCounterAlias(String hierarchy) {
        return hierarchy + "Counter";
    }

    private static void addHierarchySelect(AOQueryGenerator generator, String hierarchy, String columnJoin) {
        String hierarchyCounter = WorkItemDependencySQL.getHierarchyCounterAlias(hierarchy);
        generator.colId(hierarchy).col(hierarchy, "title").col(hierarchy, "type").col(hierarchy, "status").raw(", (CASE WHEN ").col("d", columnJoin).eq().colId(hierarchy).raw("THEN").bool(true).raw("ELSE").bool(false).raw("END)").raw(",").appendTableAlias(hierarchyCounter).raw(".").quoted(CHILDCOUNT).raw(",").appendTableAlias(hierarchyCounter).raw(".").quoted(OPENCHILDCOUNT).setLastCol(true);
    }

    private static void addChildCountJoin(AOQueryGenerator generator, String hierarchy) {
        String hierarchyCounter = WorkItemDependencySQL.getHierarchyCounterAlias(hierarchy);
        generator.leftJoin().raw("(").select().col(hierarchyCounter, "aoParent").raw(", COUNT(*) AS").quoted(CHILDCOUNT).raw(", SUM(").raw("CASE WHEN").col(hierarchyCounter, "status").neq().numeric(WorkItemStatus.COMPLETED.value()).raw("THEN 1 ELSE 0 END").raw(") AS").quoted(OPENCHILDCOUNT).from(hierarchyCounter).groupBy().col(hierarchyCounter, "aoParent").raw(") ").quoted(hierarchyCounter).on().col(hierarchyCounter, "aoParent").eq().colId(hierarchy);
    }
}

