/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.people;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.IAbility;
import com.radiantminds.roadmap.common.data.entities.people.IAbsence;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.people.IPresence;
import com.radiantminds.roadmap.common.data.entities.people.IResource;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingAbility;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.rest.entities.RestUtils;
import com.radiantminds.roadmap.common.rest.entities.common.BaseRestDescribable;
import com.radiantminds.roadmap.common.rest.entities.people.RestAbility;
import com.radiantminds.roadmap.common.rest.entities.people.RestAbsence;
import com.radiantminds.roadmap.common.rest.entities.people.RestPresence;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="person")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestPerson
extends BaseRestDescribable
implements IPerson {
    @XmlElement
    private String externalId;
    @XmlElement
    private Boolean isExternal;
    @XmlElement(name="abilities")
    private List<RestAbility> abilities;
    @XmlElement
    private List<RestPresence> presences;
    @XmlElement
    private List<RestAbsence> absences;
    private List<IResource> resources;
    private IPlan plan;

    @Deprecated
    private RestPerson() {
    }

    public RestPerson(String id, String title, String description, String externalId) {
        super(id, title, description);
        this.externalId = externalId;
    }

    public RestPerson(IPerson person) {
        super(person);
        this.externalId = person.getExternalId().isPresent() ? (String)person.getExternalId().get() : null;
        this.setAbilities(person.getAbilities());
        this.resources = person.getResources();
        this.isExternal = person.isExternal();
        this.presences = Lists.newArrayList();
        for (IPresence iPresence : person.getPresenceIntervals()) {
            this.presences.add(new RestPresence(iPresence));
        }
        this.absences = Lists.newArrayList();
        for (IAbsence iAbsence : person.getAbsenceIntervals()) {
            this.absences.add(new RestAbsence(iAbsence));
        }
        this.plan = person.getPlan();
    }

    @Override
    public Optional<String> getExternalId() {
        return Optional.fromNullable((Object)this.externalId);
    }

    @Override
    public void setExternalId(String id) {
        this.externalId = id;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public void setExternal(boolean external) {
        this.isExternal = external;
    }

    @Override
    public List<IAbility> getAbilities() {
        if (this.abilities != null) {
            return Lists.newArrayList(this.abilities);
        }
        return Lists.newArrayList();
    }

    @Override
    public Optional<IAbility> getAbilityForSkill(String skillId) {
        for (IAbility ability : this.getAbilities()) {
            if (!ability.getTargetType().equals("skill") || !String.valueOf(ability.getTargetId()).equals(skillId)) continue;
            return Optional.of((Object)ability);
        }
        return Optional.absent();
    }

    @Override
    public Optional<IAbility> getAbilityForStage(String stageId) {
        for (IAbility ability : this.getAbilities()) {
            if (!ability.getTargetType().equals("stage") || !String.valueOf(ability.getTargetId()).equals(stageId)) continue;
            return Optional.of((Object)ability);
        }
        return Optional.absent();
    }

    public void setAbilities(List<IAbility> abilities) {
        this.abilities = Lists.newArrayList();
        for (IAbility ability : abilities) {
            RestAbility restAbility = new RestAbility(ability);
            this.abilities.add(restAbility);
        }
    }

    @Override
    public List<IResource> getResources() {
        return RestUtils.getNullSafeList(this.resources);
    }

    @Override
    public IPlan getPlan() {
        return this.plan;
    }

    @Override
    public void setPlan(IPlan plan) {
        this.plan = plan;
    }

    @Override
    public List<IPresence> getPresenceIntervals() {
        if (this.presences != null) {
            return Lists.newArrayList(this.presences);
        }
        return Lists.newArrayList();
    }

    public void setPresenceIntervals(List<RestPresence> presences) {
        this.presences = presences;
    }

    @Override
    public List<IAbsence> getAbsenceIntervals() {
        if (this.absences != null) {
            return Lists.newArrayList(this.absences);
        }
        return Lists.newArrayList();
    }

    public void setAbsenceIntervals(List<RestAbsence> absences) {
        this.absences = absences;
    }

    @Override
    public List<? extends SchedulingAbility> getPersonAbilities() {
        return RestUtils.getNullSafeList(this.abilities);
    }
}

