/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.BoundAvailability;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.ConstantStepWiseResourceAvailability;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IStepWiseResourceAvailability;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IBoundedStepFunction;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.MutableBoundedStepFunctionTroveImpl;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;

public class StepWiseResourceAvailability
implements IStepWiseResourceAvailability {
    private static final Log LOGGER = Log.with(StepWiseResourceAvailability.class);
    private final float defaultAvailability;
    private final IBoundedStepFunction irregularBoundedFunction;

    public StepWiseResourceAvailability(float defaultAvailability, IBoundedStepFunction irregularBoundedFunction) {
        this.defaultAvailability = defaultAvailability;
        this.irregularBoundedFunction = irregularBoundedFunction;
    }

    @Override
    public float getAvailability(int timeStep) {
        if (!this.irregularBoundedFunction.contains(timeStep)) {
            return this.defaultAvailability;
        }
        return this.irregularBoundedFunction.getAt(timeStep);
    }

    @Override
    public float getAvailabilityInInterval(IIntegerInterval interval) {
        float sum = 0.0f;
        for (int i = interval.getStart(); i <= interval.getEnd(); ++i) {
            sum += this.getAvailability(i);
        }
        return sum;
    }

    @Override
    public List<IIntegerInterval> getAbsenceIntervals() {
        return this.irregularBoundedFunction.getZeroIntervals();
    }

    @Override
    public int getFirstRegularTimeStep() {
        return this.irregularBoundedFunction.getUpperSpecificationBound() + 1;
    }

    @Override
    public boolean isPositiveEnding() {
        return this.defaultAvailability > 0.0f;
    }

    public String toString() {
        return "StepWiseResourceAvailability [defaultAvailability=" + this.defaultAvailability + ", availabilityFunction=" + this.irregularBoundedFunction + "]";
    }

    public static Optional<IStepWiseResourceAvailability> createInstance(float defaultAvailability) {
        return StepWiseResourceAvailability.createInstance(Collections.emptyList(), defaultAvailability);
    }

    public static Optional<IStepWiseResourceAvailability> createInstance(List<BoundAvailability> prioritizedAvailabilities, float defaultAvailability) {
        LogUtil.debug(LOGGER, "create instance with default availability %s and exceptions: %s", Float.valueOf(defaultAvailability), Joiner.on((String)",").join(prioritizedAvailabilities));
        if (prioritizedAvailabilities.isEmpty()) {
            LogUtil.debug(LOGGER, "no special availabilities - create constant");
            if (defaultAvailability <= 0.0f) {
                LOGGER.debug("no valid availability function", new Object[0]);
                return Optional.absent();
            }
            ConstantStepWiseResourceAvailability constantAvailability = new ConstantStepWiseResourceAvailability(defaultAvailability);
            LogUtil.debug(LOGGER, "created constant availability function: %s", constantAvailability);
            return Optional.of((Object)constantAvailability);
        }
        LogUtil.debug(LOGGER, "create availability function with exceptions");
        MutableBoundedStepFunctionTroveImpl exceptionFunction = new MutableBoundedStepFunctionTroveImpl(RmUtils.getMinStart(Sets.newHashSet(prioritizedAvailabilities)), RmUtils.getMaxEnd(Sets.newHashSet(prioritizedAvailabilities)), defaultAvailability);
        for (BoundAvailability boundAvailability : Lists.reverse(prioritizedAvailabilities)) {
            LogUtil.debug(LOGGER, "adapt availability function with exception: %s", boundAvailability);
            exceptionFunction.setIn(boundAvailability.getStart(), boundAvailability.getEnd(), boundAvailability.getAvailability());
        }
        StepWiseResourceAvailability instance = new StepWiseResourceAvailability(defaultAvailability, exceptionFunction);
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return Optional.of((Object)instance);
    }
}

