/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class EpisodeSchedule
implements IEpisodeSchedule {
    private final IEpisode episode;
    private final IIntegerInterval activeInterval;
    private final Set<IActivitySetSchedule> activitySetSchedules;
    private final Set<IUnstructuredItemSchedule> unstructuredItemSchedules;
    private final Set<IScheduleViolation> scheduleViolations;
    private final Set<IScheduleWarning> warnings;
    private final int releaseTime;
    private final Set<IWorkAssignment> workAssignments;

    private EpisodeSchedule(IEpisode episode, IIntegerInterval activeInterval, Set<IActivitySetSchedule> activitySetSolutions, Set<IUnstructuredItemSchedule> packageSolutions, Set<IWorkAssignment> workAssignments, Set<IScheduleViolation> scheduleViolations, Set<IScheduleWarning> warnings, int releaseTime) {
        this.episode = episode;
        this.activeInterval = activeInterval;
        this.activitySetSchedules = Collections.unmodifiableSet(activitySetSolutions);
        this.unstructuredItemSchedules = Collections.unmodifiableSet(packageSolutions);
        this.scheduleViolations = Collections.unmodifiableSet(scheduleViolations);
        this.warnings = Collections.unmodifiableSet(warnings);
        this.releaseTime = releaseTime;
        this.workAssignments = workAssignments;
    }

    @Override
    public int getStart() {
        return this.activeInterval.getStart();
    }

    @Override
    public int getEnd() {
        return this.activeInterval.getEnd();
    }

    @Override
    public String getId() {
        return this.episode.getId();
    }

    @Override
    public Set<IActivitySetSchedule> getActivitySetSchedules() {
        return this.activitySetSchedules;
    }

    @Override
    public IEpisode getEpisode() {
        return this.episode;
    }

    @Override
    public Set<IUnstructuredItemSchedule> getUnstructuredItemSchedules() {
        return this.unstructuredItemSchedules;
    }

    @Override
    public int getLength() {
        return this.activeInterval.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.activeInterval.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.activeInterval.getOverlappingInterval(interval);
    }

    @Override
    public Set<IScheduleViolation> getViolations() {
        return this.scheduleViolations;
    }

    @Override
    public Set<IScheduleWarning> getWarnings() {
        return this.warnings;
    }

    @Override
    public Set<IWorkAssignment> getWorkAssignments() {
        return this.workAssignments;
    }

    @Override
    public boolean isDelayed() {
        return this.episode.getFixedEndTime().isPresent() && (Integer)this.episode.getFixedEndTime().get() < this.getEnd();
    }

    @Override
    public Optional<IIntegerInterval> tryGetInterval(String itemId) {
        Optional<IActivitySetSchedule> activitySetSchedule = RmIdentifiableUtils.tryFindElementWithId(itemId, this.activitySetSchedules);
        if (activitySetSchedule.isPresent()) {
            return Optional.of((Object)((IIntegerInterval)activitySetSchedule.get()));
        }
        Optional<IUnstructuredItemSchedule> unstructSchedule = RmIdentifiableUtils.tryFindElementWithId(itemId, this.unstructuredItemSchedules);
        if (unstructSchedule.isPresent()) {
            return Optional.of((Object)((IIntegerInterval)unstructSchedule.get()));
        }
        return Optional.absent();
    }

    @Override
    public boolean isEmpty() {
        return this.activeInterval.getLength() <= 0;
    }

    @Override
    public int getReleaseTime() {
        return this.releaseTime;
    }

    public static IEpisodeSchedule createInstance(IEpisode episode, Set<IActivitySetSchedule> activitySetSolutions, Set<IUnstructuredItemSchedule> unstructuredSolutions, @Nullable Integer releaseTime) {
        Preconditions.checkNotNull((Object)episode, (Object)"project episode must not be null");
        Preconditions.checkNotNull(activitySetSolutions, (Object)"activity set solutions must not be null");
        Preconditions.checkNotNull(unstructuredSolutions, (Object)"unstructured item solutions must not be null");
        IIntegerInterval interval = RmUtils.getMergedIntervals(Sets.union(activitySetSolutions, unstructuredSolutions));
        if (interval.getLength() == 0) {
            interval = new IntegerInterval(0, -1);
        }
        if (releaseTime == null) {
            releaseTime = 0;
        }
        return new EpisodeSchedule(episode, interval, activitySetSolutions, unstructuredSolutions, EpisodeSchedule.getAllWorkAssignments(activitySetSolutions, unstructuredSolutions), Sets.newHashSet(), EpisodeSchedule.getAllWarnings(activitySetSolutions, unstructuredSolutions), releaseTime);
    }

    private static Set<IWorkAssignment> getAllWorkAssignments(Set<IActivitySetSchedule> activitySetSolutions, Set<IUnstructuredItemSchedule> unstructuredSolutions) {
        HashSet allWorkAssignments = Sets.newHashSet();
        for (IActivitySetSchedule activitySetSolution : activitySetSolutions) {
            allWorkAssignments.addAll(activitySetSolution.getWorkAssignments());
        }
        for (IUnstructuredItemSchedule unstructuredSolution : unstructuredSolutions) {
            allWorkAssignments.addAll(unstructuredSolution.getWorkAssignments());
        }
        return allWorkAssignments;
    }

    private static Set<IScheduleWarning> getAllWarnings(Set<IActivitySetSchedule> activitySetSolutions, Set<IUnstructuredItemSchedule> unstructuredSolutions) {
        HashSet warnings = Sets.newHashSet();
        for (IActivitySetSchedule iActivitySetSchedule : activitySetSolutions) {
            warnings.addAll(iActivitySetSchedule.getWarnings());
        }
        for (IUnstructuredItemSchedule iUnstructuredItemSchedule : unstructuredSolutions) {
            warnings.addAll(iUnstructuredItemSchedule.getWarnings());
        }
        return warnings;
    }

    public static IEpisodeSchedule createEmpty(IEpisode episode, int startTime) {
        return EpisodeSchedule.createInstance(episode, Sets.newHashSet(), Sets.newHashSet(), startTime);
    }
}

