/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import java.sql.SQLException;

public class DefaultEstimateExtractor {
    private PortfolioWorkItemPersistence workItemPersistence;
    private PortfolioPlanPersistence planPersistence;

    public DefaultEstimateExtractor(PortfolioWorkItemPersistence workItemPersistence, PortfolioPlanPersistence planPersistence) {
        this.workItemPersistence = workItemPersistence;
        this.planPersistence = planPersistence;
    }

    public Optional<Double> defaultEstimateForWorkItem(String workItemId) throws PersistenceException, SQLException {
        IWorkItem workItem = (IWorkItem)this.workItemPersistence.get(workItemId);
        String planId = workItem.getPlan().getId();
        IPlanConfiguration config = this.planPersistence.getPlanConfiguration(planId);
        return this.defaultEstimateForWorkItem(workItem, config);
    }

    public Optional<Double> defaultEstimateForWorkItem(IWorkItem workItem, SchedulingConfig config) throws PersistenceException, SQLException {
        if (workItem.isStory()) {
            return Optional.fromNullable((Object)config.getDefaultStoryEstimate());
        }
        if (workItem.isEpic()) {
            return Optional.fromNullable((Object)config.getDefaultEpicEstimate());
        }
        return Optional.absent();
    }
}

