/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.teams;

import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.people.IResource;
import com.radiantminds.roadmap.common.data.entities.people.ISprint;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOResource;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOSprint;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSprintPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.people.RestPlanningMode;
import com.radiantminds.roadmap.common.rest.entities.people.RestResource;
import com.radiantminds.roadmap.common.rest.entities.people.RestSprint;
import java.sql.SQLException;
import java.util.List;
import javax.ws.rs.core.Response;

public interface TeamServiceHandler {
    @AuthorizedPlanReadAccess
    public Response getAllResources(EntityContext<ITeam> var1) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Off)
    public Response addResourceToTeam(EntityContext<ITeam> var1, RestResource var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Off)
    public Response rankResource(EntityContext<ITeam> var1, RestRank var2) throws Exception;

    @AuthorizedPlanReadAccess
    public Response getAllSprints(EntityContext<ITeam> var1) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Off)
    public Response addSprintToTeam(EntityContext<ITeam> var1, RestSprint var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Off)
    public Response rankSprint(EntityContext<ITeam> var1, RestRank var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.On)
    public Response setPlanningMode(EntityContext<ITeam> var1, RestPlanningMode var2) throws Exception;

    public static class Impl
    implements TeamServiceHandler {
        private final PortfolioResourcePersistence resourcePersistence;
        private final PortfolioPersonPersistence personPersistence;
        private final PortfolioSprintPersistence sprintPersistence;
        private final PortfolioTeamPersistence teamPersistence;
        private final PortfolioPlanPersistence planPersistence;
        private final SubCollectionUtils subCollectionUtils;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, PortfolioResourcePersistence resourcePersistence, PortfolioPersonPersistence personPersistence, PortfolioSprintPersistence sprintPersistence, PortfolioTeamPersistence teamPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioPlanPersistence planPersistence) {
            this.resourcePersistence = resourcePersistence;
            this.personPersistence = personPersistence;
            this.sprintPersistence = sprintPersistence;
            this.teamPersistence = teamPersistence;
            this.planPersistence = planPersistence;
            this.subCollectionUtils = new SubCollectionUtils(activeObjectsUtilities, workItemPersistence);
        }

        @Override
        public Response getAllResources(EntityContext<ITeam> entityContext) throws Exception {
            List<IResource> resources = this.resourcePersistence.listForTeam(entityContext.getEntityId());
            return entityContext.okForList(Iterables.toArray(ToRest.transferList(RestResource.class, IResource.class, resources), RestResource.class));
        }

        @Override
        public Response addResourceToTeam(EntityContext<ITeam> entityContext, RestResource newResource) throws Exception {
            final IPerson parentPerson = (IPerson)this.personPersistence.get(newResource.getPersonId());
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AOResource.class, "team", newResource, new SubCollectionUtilsCallback.Adapter<ITeam, IResource, RestResource>(){

                @Override
                public void setParent(ITeam parent, IResource entity) {
                    entity.setTeam(parent);
                    entity.setPerson(parentPerson);
                }

                @Override
                public IResource persist(IResource entity) throws PersistenceException {
                    return resourcePersistence.persist(entity);
                }

                @Override
                public IResource get(String id) throws Exception {
                    return (IResource)resourcePersistence.get(id);
                }
            });
        }

        @Override
        public Response rankResource(EntityContext<ITeam> entityContext, RestRank rank) throws Exception {
            return this.subCollectionUtils.rankEntity(entityContext, AOResource.class, this.resourcePersistence, "team", rank);
        }

        @Override
        public Response getAllSprints(EntityContext<ITeam> entityContext) throws Exception {
            List<ISprint> sprints = this.sprintPersistence.listForTeam(entityContext.getEntityId());
            return entityContext.okForList(Iterables.toArray(ToRest.transferList(RestSprint.class, ISprint.class, sprints), RestSprint.class));
        }

        @Override
        public Response addSprintToTeam(EntityContext<ITeam> entityContext, RestSprint newSprint) throws Exception {
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AOSprint.class, "team", newSprint, new SubCollectionUtilsCallback.Adapter<ITeam, ISprint, RestSprint>(){

                @Override
                public void setParent(ITeam parent, ISprint entity) {
                    entity.setTeam(parent);
                }

                @Override
                public ISprint persist(ISprint entity) throws PersistenceException {
                    return sprintPersistence.persist(entity);
                }

                @Override
                public ISprint get(String id) throws Exception {
                    return (ISprint)sprintPersistence.get(id);
                }
            });
        }

        @Override
        public Response rankSprint(EntityContext<ITeam> entityContext, RestRank rank) throws Exception {
            return this.subCollectionUtils.rankEntity(entityContext, AOSprint.class, this.sprintPersistence, "team", rank);
        }

        @Override
        public Response setPlanningMode(EntityContext<ITeam> teamEntityContext, RestPlanningMode restPlanningMode) throws Exception {
            PlanningMode planningMode = restPlanningMode.getPlanningMode();
            if (planningMode == PlanningMode.Kanban && this.isUsingStoryPoints(teamEntityContext)) {
                return ResponseBuilder.badRequest(RestMessaging.warning("kanban-not-allowed"));
            }
            this.teamPersistence.setPlanningMode(teamEntityContext.getEntityId(), planningMode);
            return teamEntityContext.okForEntityUpdate();
        }

        private boolean isUsingStoryPoints(EntityContext<ITeam> teamEntityContext) throws SQLException {
            String planningUnitUsedByTeam = this.getPlanningUnitUsedByTeam(teamEntityContext);
            String storyPointPlanningUnit = PlanningUnit.STORY_POINTS.unit();
            return storyPointPlanningUnit.equals(planningUnitUsedByTeam);
        }

        private String getPlanningUnitUsedByTeam(EntityContext<ITeam> teamEntityContext) throws SQLException {
            String planId = teamEntityContext.getEntityInfo().getPlanId();
            IPlanConfiguration configuration = this.planPersistence.getPlanConfiguration(planId);
            return configuration.getPlanningUnit();
        }
    }
}

