/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.TransformedWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ISingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

class TransformedGroupAssignment
implements ISingleResourceGroupAssignment {
    private final Set<IWorkAssignment> workAssignments;
    private final IWorkSlot workSlot;

    static TransformedGroupAssignment create(Set<FixedSlotWorkAssignment> assignments, IWorkSlot workSlot, IEpisode episode) {
        return new TransformedGroupAssignment(TransformedGroupAssignment.transform(assignments, episode), workSlot);
    }

    private static Set<IWorkAssignment> transform(Set<FixedSlotWorkAssignment> assignments, IEpisode episode) {
        HashSet transformed = Sets.newHashSet();
        for (FixedSlotWorkAssignment assignment : assignments) {
            transformed.add(new TransformedWorkAssignment(assignment, episode));
        }
        return transformed;
    }

    TransformedGroupAssignment(Set<IWorkAssignment> workAssignments, IWorkSlot workSlot) {
        this.workAssignments = workAssignments;
        this.workSlot = workSlot;
    }

    @Override
    public Set<IWorkAssignment> getWorkAssignments() {
        return this.workAssignments;
    }

    @Override
    public Set<IWorkSlot> getUsedWorkSlots() {
        return Sets.newHashSet((Object[])new IWorkSlot[]{this.workSlot});
    }

    @Override
    public int getStart() {
        return this.workSlot.getStart();
    }

    @Override
    public int getEnd() {
        return this.workSlot.getEnd();
    }

    @Override
    public int getLength() {
        return this.workSlot.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.workSlot.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.workSlot.getOverlappingInterval(interval);
    }
}

