/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisodeStream;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TimePlan
implements ITimePlan {
    private final BiMap<String, IEpisodeStream> episodeStreams;
    private final Map<String, IEpisodeStream> episodeToStreamMap;

    public TimePlan(Set<IEpisodeStream> episodeStreams) {
        Preconditions.checkNotNull(episodeStreams, (Object)"streams must not be null");
        Preconditions.checkArgument((!episodeStreams.isEmpty() ? 1 : 0) != 0, (Object)"streams must not be empty");
        this.episodeStreams = RmIdentifiableUtils.createIdMap(episodeStreams);
        this.episodeToStreamMap = this.initEpisodeToStreamMap(episodeStreams);
    }

    private Map<String, IEpisodeStream> initEpisodeToStreamMap(Set<IEpisodeStream> streams) {
        HashMap episodeToStream = Maps.newHashMap();
        for (IEpisodeStream stream : streams) {
            List<IEpisode> episodes = stream.getEpisodes();
            for (IEpisode episode : episodes) {
                episodeToStream.put(episode.getId(), stream);
            }
        }
        return episodeToStream;
    }

    @Override
    public Set<IEpisodeStream> getEpisodeStreams() {
        return this.episodeStreams.values();
    }

    @Override
    public Optional<IEpisodeStream> getStreamForEpisode(String episodeId) {
        return Optional.fromNullable((Object)this.episodeToStreamMap.get(episodeId));
    }

    @Override
    public IEpisodeStream getEpisodeStream(String streamId) {
        return (IEpisodeStream)this.episodeStreams.get((Object)streamId);
    }

    @Override
    public boolean isEpisodeStrictlyBefore(String episodeId1, String episodeId2) {
        IEpisodeStream stream2;
        if (episodeId1.equals(episodeId2)) {
            return false;
        }
        IEpisodeStream stream1 = this.episodeToStreamMap.get(episodeId1);
        if (!stream1.equals(stream2 = this.episodeToStreamMap.get(episodeId2))) {
            return false;
        }
        return stream1.isEpisodeStrictlyBefore(episodeId1, episodeId2);
    }

    @Override
    public IEpisode getEpisode(String episodeId) {
        return this.episodeToStreamMap.get(episodeId).getEpisode(episodeId);
    }

    @Override
    public Optional<IEpisode> tryGetEpisode(String episodeId) {
        IEpisodeStream stream = this.episodeToStreamMap.get(episodeId);
        if (stream == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)stream.getEpisode(episodeId));
    }

    public String toString() {
        return "TimePlan [episodeStreams=" + Joiner.on((String)",").join((Iterable)this.episodeStreams.values()) + "]";
    }

    @Override
    public Set<IEpisode> getEpisodes() {
        HashSet episodes = Sets.newHashSet();
        for (IEpisodeStream stream : this.episodeStreams.values()) {
            episodes.addAll(stream.getEpisodes());
        }
        return episodes;
    }
}

