/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.BaseStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositiveTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ProcessingStageWorkPackage
extends BaseStageWorkPackage {
    private static final Log LOGGER = Log.with(ProcessingStageWorkPackage.class);

    ProcessingStageWorkPackage(IProcessingStage processingStage, ImmutableNonEmptyPositivePrimitivesMap<IResourceType> positiveWorkAmountMap) {
        super(processingStage, positiveWorkAmountMap);
    }

    public static Optional<IProcessingStageWorkPackage> tryCreateFromDemandMap(IProcessingStage processingStage, PositivePrimitivesMap<IResourceType> workAmountMap) {
        Preconditions.checkNotNull((Object)processingStage, (Object)"processing stage must not be null");
        LogUtil.debug(LOGGER, "create instance for stage %s for map: %s", processingStage, workAmountMap);
        Optional<ImmutableNonEmptyPositivePrimitivesMap<IResourceType>> filteredWorkAmount = ImmutableNonEmptyPositiveTroveMap.tryCreate(workAmountMap);
        if (!filteredWorkAmount.isPresent()) {
            LogUtil.debug(LOGGER, "no positive demands");
            return Optional.absent();
        }
        Set<IResourceType> stageSkills = processingStage.getResourceTypes();
        Preconditions.checkArgument((boolean)stageSkills.containsAll(((ImmutableNonEmptyPositivePrimitivesMap)filteredWorkAmount.get()).keySet()), (Object)"work amount map contains illegal argument types");
        ProcessingStageWorkPackage instance = new ProcessingStageWorkPackage(processingStage, (ImmutableNonEmptyPositivePrimitivesMap)filteredWorkAmount.get());
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return Optional.of((Object)instance);
    }
}

