/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.google.common.collect.Sets;
import com.radiantminds.roadmap.api.PluginPermission;
import com.radiantminds.roadmap.common.handlers.BadDeveloperException;
import com.radiantminds.roadmap.common.handlers.NotAuthorizedException;
import com.radiantminds.roadmap.common.handlers.SecurityAnnotations;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import java.sql.SQLException;
import java.util.HashSet;

final class PluginLevelPermissionChecker {
    PluginLevelPermissionChecker() {
    }

    static void check(SecurityAnnotations securityConfig, PluginPermissions pluginPermissionHandler) throws NotAuthorizedException, BadDeveloperException, SQLException {
        HashSet pluginPermissions = Sets.newHashSet();
        if (securityConfig.getPluginReadAccess().isPresent()) {
            pluginPermissions.add(PluginPermission.Viewer);
            pluginPermissions.add(PluginPermission.FullEditor);
            pluginPermissions.add(PluginPermission.NonPublishingEditor);
        }
        if (securityConfig.getPluginUserAccess().isPresent()) {
            pluginPermissions.add(PluginPermission.FullEditor);
            pluginPermissions.add(PluginPermission.NonPublishingEditor);
        }
        if (securityConfig.getPluginAdminAccess().isPresent()) {
            pluginPermissions.add(PluginPermission.Admin);
        }
        if (pluginPermissions.size() == 0) {
            throw new BadDeveloperException("Dear developer; y u no using at least plugin authorization annotations? Making me sad and angry.");
        }
        if (!pluginPermissionHandler.check(PluginPermission.or(pluginPermissions))) {
            throw new NotAuthorizedException();
        }
    }
}

