/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.persons;

import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IAbsence;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.people.IPresence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals.AOAbsence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals.AOPresence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbilityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbsenceIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPresenceIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.people.RestAbsence;
import com.radiantminds.roadmap.common.rest.entities.people.RestPresence;
import java.util.List;
import javax.ws.rs.core.Response;

public interface PersonServiceHandler {
    @AuthorizedPlanUserAccess
    public Response setSkillAbility(EntityContext<IPerson> var1, String var2, Double var3) throws Exception;

    @AuthorizedPlanUserAccess
    public Response setStageAbility(EntityContext<IPerson> var1, String var2, Double var3) throws Exception;

    @AuthorizedPlanReadAccess
    public Response getAllAbsences(EntityContext<IPerson> var1) throws Exception;

    @AuthorizedPlanUserAccess(incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Off)
    public Response rankAbsences(EntityContext<IPerson> var1, RestRank var2) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Off)
    public Response addAbsenceToPerson(EntityContext<IPerson> var1, RestAbsence var2) throws Exception;

    @AuthorizedPlanReadAccess
    public Response getAllPresences(EntityContext<IPerson> var1) throws Exception;

    @AuthorizedPlanUserAccess(incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Off)
    public Response rankPresence(EntityContext<IPerson> var1, RestRank var2) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Off)
    public Response addPresenceToPerson(EntityContext<IPerson> var1, RestPresence var2) throws Exception;

    public static class Impl
    implements PersonServiceHandler {
        private final PortfolioAbilityPersistence abilityPersistence;
        private final PortfolioAbsenceIntervalPersistence absencePersistence;
        private final PortfolioPresenceIntervalPersistence presencePersistence;
        private final SubCollectionUtils subCollectionUtils;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, PortfolioAbilityPersistence abilityPersistence, PortfolioAbsenceIntervalPersistence absencePersistence, PortfolioPresenceIntervalPersistence presencePersistence, PortfolioWorkItemPersistence workItemPersistence) {
            this.abilityPersistence = abilityPersistence;
            this.absencePersistence = absencePersistence;
            this.presencePersistence = presencePersistence;
            this.subCollectionUtils = new SubCollectionUtils(activeObjectsUtilities, workItemPersistence);
        }

        @Override
        public Response setStageAbility(EntityContext<IPerson> entityContext, String stageId, Double abilityValue) throws Exception {
            this.abilityPersistence.setAbility(entityContext.getEntityId(), "stage", stageId, abilityValue);
            return entityContext.okForEntityUpdate();
        }

        @Override
        public Response setSkillAbility(EntityContext<IPerson> entityContext, String skillId, Double abilityValue) throws Exception {
            this.abilityPersistence.setAbility(entityContext.getEntityId(), "skill", skillId, abilityValue);
            return entityContext.okForEntityUpdate();
        }

        @Override
        public Response getAllAbsences(EntityContext<IPerson> entityContext) throws Exception {
            List<IAbsence> intervals = this.absencePersistence.listForPerson(entityContext.getEntityId());
            return entityContext.okForList(Iterables.toArray(ToRest.transferList(RestAbsence.class, IAbsence.class, intervals), RestAbsence.class));
        }

        @Override
        public Response rankAbsences(EntityContext<IPerson> entityContext, RestRank rank) throws Exception {
            return this.subCollectionUtils.rankEntity(entityContext, AOAbsence.class, this.absencePersistence, "person", rank);
        }

        @Override
        public Response addAbsenceToPerson(EntityContext<IPerson> entityContext, RestAbsence newAbsence) throws Exception {
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AOAbsence.class, "person", newAbsence, new SubCollectionUtilsCallback.Adapter<IPerson, IAbsence, RestAbsence>(){

                @Override
                public void setParent(IPerson parent, IAbsence entity) {
                    entity.setPerson(parent);
                }

                @Override
                public IAbsence persist(IAbsence entity) throws Exception {
                    return absencePersistence.persist(entity);
                }

                @Override
                public IAbsence get(String id) throws Exception {
                    return (IAbsence)absencePersistence.get(id);
                }
            });
        }

        @Override
        public Response getAllPresences(EntityContext<IPerson> entityContext) throws Exception {
            List<IPresence> intervals = this.presencePersistence.listForPerson(entityContext.getEntityId());
            return entityContext.okForList(Iterables.toArray(ToRest.transferList(RestPresence.class, IPresence.class, intervals), RestPresence.class));
        }

        @Override
        public Response rankPresence(EntityContext<IPerson> entityContext, RestRank rank) throws Exception {
            return this.subCollectionUtils.rankEntity(entityContext, AOPresence.class, this.presencePersistence, "person", rank);
        }

        @Override
        public Response addPresenceToPerson(EntityContext<IPerson> entityContext, RestPresence newPresence) throws Exception {
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AOPresence.class, "person", newPresence, new SubCollectionUtilsCallback.Adapter<IPerson, IPresence, RestPresence>(){

                @Override
                public void setParent(IPerson parent, IPresence entity) {
                    entity.setPerson(parent);
                }

                @Override
                public IPresence persist(IPresence entity) throws Exception {
                    return presencePersistence.persist(entity);
                }

                @Override
                public IPresence get(String id) throws Exception {
                    return (IPresence)presencePersistence.get(id);
                }
            });
        }
    }
}

