/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.analytics;

import com.radiantminds.roadmap.common.extensions.analytics.PlanProperties;
import com.radiantminds.roadmap.jira.common.analytics.EventProperty;

public class BaseCalculationEvent {
    private final String calculationId;
    private final String schedulingMode;
    private final String planningUnit;
    private final Long numberOfUnstructuredEpics;
    private final Double averageUnstructuredEpicEstimate;
    private final Double unstructuredEpicEstimateStandardDeviation;
    private final Long numberOfStories;
    private final Double averageStoryEstimate;
    private final Double storyEstimateStandardDeviation;
    private final Long numberOfDependencies;
    private final Long numberOfScrumTeams;
    private final Long numberOfKanbanTeams;
    private final Long numberOfStrictTeamAssignments;
    private final Long numberOfResources;
    private final Long numberOfStrictResourceAssignments;
    private final Long numberOfStages;
    private final Long numberOfSkills;
    private final Double averageSkillsPerResource;
    private final Double skillsPerResourceStandardDeviation;
    private final Double skillsPerStageStandardDeviation;
    private final Long numberOfDynamicReleases;
    private final Long numberOfFixedEndDateReleases;
    private final Long numberOfStrictReleaseAssignments;

    public BaseCalculationEvent(String calculationId, String schedulingMode, PlanProperties planProperties) {
        this.calculationId = calculationId;
        this.schedulingMode = schedulingMode;
        this.planningUnit = planProperties.getPlanningUnit();
        this.numberOfUnstructuredEpics = planProperties.getNumberOfUnstructuredEpics();
        this.averageUnstructuredEpicEstimate = planProperties.getAverageUnstructuredEpicEstimate();
        this.unstructuredEpicEstimateStandardDeviation = planProperties.getUnstructuredEpicEstimateStandardDeviation();
        this.numberOfStories = planProperties.getNumberOfStories();
        this.averageStoryEstimate = planProperties.getAverageStoryEstimate();
        this.storyEstimateStandardDeviation = planProperties.getStoryEstimateStandardDeviation();
        this.numberOfDependencies = planProperties.getNumberOfDependencies();
        this.numberOfScrumTeams = planProperties.getNumberOfScrumTeams();
        this.numberOfKanbanTeams = planProperties.getNumberOfKanbanTeams();
        this.numberOfStrictTeamAssignments = planProperties.getNumberOfStrictTeamAssignments();
        this.numberOfResources = planProperties.getNumberOfResources();
        this.numberOfStrictResourceAssignments = planProperties.getNumberOfStrictResourceAssignments();
        this.numberOfStages = planProperties.getNumberOfStages();
        this.numberOfSkills = planProperties.getNumberOfSkills();
        this.averageSkillsPerResource = planProperties.getAverageSkillsPerResource();
        this.skillsPerResourceStandardDeviation = planProperties.getSkillsPerResourceStandardDeviation();
        this.skillsPerStageStandardDeviation = planProperties.getSkillsPerStageStandardDeviation();
        this.numberOfDynamicReleases = planProperties.getNumberOfDynamicReleases();
        this.numberOfFixedEndDateReleases = planProperties.getNumberOfFixedEndDateReleases();
        this.numberOfStrictReleaseAssignments = planProperties.getNumberOfStrictReleaseAssignments();
    }

    @EventProperty
    public String getPlanningUnit() {
        return this.planningUnit;
    }

    @EventProperty
    public String getCalculationId() {
        return this.calculationId;
    }

    @EventProperty
    public String getSchedulingMode() {
        return this.schedulingMode;
    }

    @EventProperty
    public Long getNumberOfUnstructuredEpics() {
        return this.numberOfUnstructuredEpics;
    }

    @EventProperty
    public Double getAverageUnstructuredEpicsEstimate() {
        return this.averageUnstructuredEpicEstimate;
    }

    @EventProperty
    public Double getUnstructuredEpicsStandardDeviation() {
        return this.unstructuredEpicEstimateStandardDeviation;
    }

    @EventProperty
    public Long getNumberOfStories() {
        return this.numberOfStories;
    }

    @EventProperty
    public Double getAverageStoryEstimate() {
        return this.averageStoryEstimate;
    }

    @EventProperty
    public Double getStoryEstimateStandardDeviation() {
        return this.storyEstimateStandardDeviation;
    }

    @EventProperty
    public Long getNumberOfDependencies() {
        return this.numberOfDependencies;
    }

    @EventProperty
    public Long getNumberOfScrumTeams() {
        return this.numberOfScrumTeams;
    }

    @EventProperty
    public Long getNumberOfKanbanTeams() {
        return this.numberOfKanbanTeams;
    }

    @EventProperty
    public Long getNumberOfStrictTeamAssignments() {
        return this.numberOfStrictTeamAssignments;
    }

    @EventProperty
    public Long getNumberOfResources() {
        return this.numberOfResources;
    }

    @EventProperty
    public Long getNumberOfStrictResourceAssignments() {
        return this.numberOfStrictResourceAssignments;
    }

    @EventProperty
    public Long getNumberOfStages() {
        return this.numberOfStages;
    }

    @EventProperty
    public Long getNumberOfSkills() {
        return this.numberOfSkills;
    }

    @EventProperty
    public Double getAverageSkillsPerResource() {
        return this.averageSkillsPerResource;
    }

    @EventProperty
    public Double getSkillsPerResourceStandardDeviation() {
        return this.skillsPerResourceStandardDeviation;
    }

    @EventProperty
    public Double getSkillsPerStageStandardDeviation() {
        return this.skillsPerStageStandardDeviation;
    }

    @EventProperty
    public Long getNumberOfDynamicReleases() {
        return this.numberOfDynamicReleases;
    }

    @EventProperty
    public Long getNumberOfFixedEndDateReleases() {
        return this.numberOfFixedEndDateReleases;
    }

    @EventProperty
    public Long getNumberOfStrictReleaseAssignments() {
        return this.numberOfStrictReleaseAssignments;
    }
}

