/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import java.util.List;
import javax.annotation.Nullable;

public class LinkUtils {
    public static Optional<IStage> getStageFromLink(IExtensionLink link, List<IStage> stages) {
        final Optional<Integer> stageId = LinkUtils.getStageIdFromLink(link.getExtensionKey());
        if (!stageId.isPresent()) {
            return Optional.absent();
        }
        IStage stage = (IStage)Iterables.find(stages, (Predicate)new Predicate<IStage>(){

            public boolean apply(@Nullable IStage stage) {
                return stage != null && String.valueOf(stageId.get()).equals(stage.getId());
            }
        });
        return Optional.of((Object)stage);
    }

    public static Optional<Integer> getStageIdFromLink(String extensionKey) {
        if (!extensionKey.startsWith("jira-issue-stage-")) {
            return Optional.absent();
        }
        return Optional.of((Object)Integer.parseInt(extensionKey.replace("jira-issue-stage-", "").trim()));
    }
}

