/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira;

import com.google.common.base.MoreObjects;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PortfolioToJiraSyncConfiguration;

class PlanInformation {
    private final IPlanConfiguration planConfiguration;
    private final PortfolioToJiraSyncConfiguration syncConfiguration;
    private final PlanningUnit planningUnit;
    private final double hoursPerDay;

    private PlanInformation(IPlanConfiguration planConfiguration, PortfolioToJiraSyncConfiguration syncConfiguration, PlanningUnit planningUnit, double hoursPerDay) {
        this.planConfiguration = planConfiguration;
        this.syncConfiguration = syncConfiguration;
        this.planningUnit = planningUnit;
        this.hoursPerDay = hoursPerDay;
    }

    public IPlanConfiguration getPlanConfiguration() {
        return this.planConfiguration;
    }

    public PortfolioToJiraSyncConfiguration getSyncConfiguration() {
        return this.syncConfiguration;
    }

    public PlanningUnit getPlanningUnit() {
        return this.planningUnit;
    }

    public double getHoursPerDay() {
        return this.hoursPerDay;
    }

    public static PlanInformation create(IPlanConfiguration planConfiguration) {
        PortfolioToJiraSyncConfiguration syncConfiguration = PortfolioToJiraSyncConfiguration.fromPlanConfiguration(planConfiguration);
        PlanningUnit planningUnit = PlanningUnit.from(planConfiguration.getPlanningUnit());
        double hoursPerDay = (Double)MoreObjects.firstNonNull((Object)planConfiguration.getHoursPerDay(), (Object)8.0);
        return new PlanInformation(planConfiguration, syncConfiguration, planningUnit, hoursPerDay);
    }
}

