/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.utils.stages.StagePercentageUtil;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.LinkUtils;
import java.util.List;
import java.util.Map;

class StageInformation {
    private static final Log LOGGER = Log.with(StageInformation.class);
    private final List<IStage> stages;
    private final Map<String, IStage> stagesById;
    private final Map<String, Double> stagePercentages;

    public StageInformation(List<IStage> stages, Map<String, IStage> stagesById, Map<String, Double> stagePercentages) {
        this.stages = stages;
        this.stagesById = stagesById;
        this.stagePercentages = stagePercentages;
    }

    public List<IStage> getStages() {
        return this.stages;
    }

    public Map<String, IStage> getStagesById() {
        return this.stagesById;
    }

    public Map<String, Double> getStagePercentages() {
        return this.stagePercentages;
    }

    public static StageInformation create(List<IStage> stages) {
        ImmutableMap stagesByID = Maps.uniqueIndex(stages, (Function)new Function<IStage, String>(){

            public String apply(IStage stage) {
                return stage.getId();
            }
        });
        Map<String, Double> stagePercentages = StagePercentageUtil.computeStagePercentages(stages);
        return new StageInformation(stages, (Map<String, IStage>)stagesByID, stagePercentages);
    }

    public Optional<IStage> getStageForLink(String extensionLinkKey) {
        Optional<Integer> stageId = LinkUtils.getStageIdFromLink(extensionLinkKey);
        if (stageId.isPresent()) {
            IStage stage = this.stagesById.get(Integer.toString((Integer)stageId.get()));
            if (stage != null) {
                return Optional.of((Object)stage);
            }
            LOGGER.warn("Stage %s could not be found. No stage-level syncing can take place.", new Object[0]);
            return Optional.absent();
        }
        return Optional.absent();
    }
}

