/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jpo2.api.plans;

import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.plugins.PluginNotAvailableException;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessor;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.atlassian.rm.common.bridges.api.plugins.access.ServiceCallback;
import com.atlassian.rm.jpo.api.plans.PlanListingService;
import com.atlassian.rm.jpo.api.plans.ProgramListingService;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.jpo2.api.Portfolio2Exception;
import com.radiantminds.roadmap.jpo2.api.common.ExceptionHandler;
import com.radiantminds.roadmap.jpo2.api.plans.DefaultPlan;
import com.radiantminds.roadmap.jpo2.api.plans.Plan;
import com.radiantminds.roadmap.jpo2.api.plans.PlanListingServiceBridge;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.radiantminds.roadmap.jpo2.api.plans.PlanListingServiceBridge00")
@SupportedVersions(all=true)
public class PlanListingServiceBridge00
implements PlanListingServiceBridge {
    private final BundleServiceAccessorProvider bundleServiceAccessorProvider;

    @Autowired
    public PlanListingServiceBridge00(BundleServiceAccessorProvider bundleServiceAccessorProvider) {
        this.bundleServiceAccessorProvider = bundleServiceAccessorProvider;
    }

    @Override
    public List<Plan> getPlans(final Set<Long> ids) throws Portfolio2Exception, PluginNotAvailableException {
        try {
            BundleServiceAccessor<PlanListingService> serviceAccessor = this.bundleServiceAccessorProvider.createServiceAccessor(PlanListingService.class);
            return serviceAccessor.perform(new ServiceCallback<PlanListingService, List<Plan>>(){

                @Override
                public List<Plan> perform(PlanListingService planListingService) throws Exception {
                    List portfolio2Plans = planListingService.getPlans(ids);
                    return Lists.newArrayList((Iterable)Iterables.transform((Iterable)portfolio2Plans, (Function)new Function<com.atlassian.rm.jpo.api.plans.Plan, Plan>(){

                        public Plan apply(com.atlassian.rm.jpo.api.plans.Plan portfolio2Plan) {
                            return new DefaultPlan(portfolio2Plan.getId(), (Optional<String>)portfolio2Plan.getTitle(), portfolio2Plan.isReadOnly());
                        }
                    }));
                }
            });
        }
        catch (Exception e) {
            return (List)ExceptionHandler.handleException(e);
        }
    }

    @Override
    public List<Plan> getAllPlans() throws PluginNotAvailableException, Portfolio2Exception {
        try {
            BundleServiceAccessor<PlanListingService> serviceAccessor = this.bundleServiceAccessorProvider.createServiceAccessor(PlanListingService.class);
            return serviceAccessor.perform(new ServiceCallback<PlanListingService, List<Plan>>(){

                @Override
                public List<Plan> perform(PlanListingService planListingService) throws Exception {
                    List portfolio2Plans = planListingService.getAllPlans();
                    return Lists.newArrayList((Iterable)Iterables.transform((Iterable)portfolio2Plans, (Function)new Function<com.atlassian.rm.jpo.api.plans.Plan, Plan>(){

                        public Plan apply(com.atlassian.rm.jpo.api.plans.Plan portfolio2Plan) {
                            return new DefaultPlan(portfolio2Plan.getId(), (Optional<String>)portfolio2Plan.getTitle(), portfolio2Plan.isReadOnly());
                        }
                    }));
                }
            });
        }
        catch (Exception e) {
            return (List)ExceptionHandler.handleException(e);
        }
    }

    @Override
    public Map<Long, String> getProgramTitle(final Set<Long> ids) throws PluginNotAvailableException, Portfolio2Exception {
        if (ids.isEmpty()) {
            return Maps.newHashMap();
        }
        BundleServiceAccessor<ProgramListingService> serviceAccessor = this.bundleServiceAccessorProvider.createServiceAccessor(ProgramListingService.class);
        try {
            return serviceAccessor.perform(new ServiceCallback<ProgramListingService, Map<Long, String>>(){

                @Override
                public Map<Long, String> perform(ProgramListingService programListingService) throws Exception {
                    return programListingService.getProgramTitles(ids);
                }
            });
        }
        catch (Exception e) {
            throw new Portfolio2Exception(e);
        }
    }
}

