/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util;

import com.atlassian.rm.jpo.scheduling.util.SortableId;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
public class SortableIdImpl
implements SortableId {
    private final String id;
    private final String sortKey;

    public SortableIdImpl(String id, String sortKey) {
        Preconditions.checkNotNull((Object)id, (Object)"id must not be null");
        Preconditions.checkNotNull((Object)sortKey, (Object)"sort key must not be null");
        this.id = id;
        this.sortKey = sortKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSortKey() {
        return this.sortKey;
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.id).append(this.sortKey).toHashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SortableId)) {
            return false;
        }
        SortableId rhs = (SortableId)obj;
        return new EqualsBuilder().append(this.id, rhs.getId()).append(this.sortKey, rhs.getSortKey()).isEquals();
    }

    public String toString() {
        return "SortableId [id=" + this.id + ", sortKey=" + this.sortKey + "]";
    }

    public static <T extends SortableId> SortableIdImpl create(T element) {
        Preconditions.checkNotNull(element, (Object)"element must not be null");
        return new SortableIdImpl(element.getId(), element.getSortKey());
    }
}

