/*
 * Decompiled with CFR 0.152.
 */
package it.com.radiantminds.plugins.jira.lucene;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldServiceBridge;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFields;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldsServiceBridgeProxy;
import com.atlassian.rm.common.bridges.agile.issuelink.AgileEpicLinkManagerServiceBridge;
import com.atlassian.rm.common.bridges.agile.issuelink.AgileEpicLinkManagerServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldHelperBridge;
import com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldHelperBridgeProxy;
import com.atlassian.rm.common.envtestutils.User;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestClassRule;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestMethodRule;
import com.atlassian.rm.common.envtestutils.WiredTestRuleFactory;
import com.atlassian.rm.common.envtestutils.annotations.AgileRequirements;
import com.atlassian.rm.common.envtestutils.annotations.JiraRequirements;
import com.atlassian.rm.common.envtestutils.annotations.Login;
import com.atlassian.rm.common.envtestutils.annotations.Projects;
import com.atlassian.rm.common.envtestutils.tools.IssueInputCallback;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.TrackerType;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemExtensionLinkData;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.stats.MonitoredCallResult;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFieldsService;
import it.com.radiantminds.plugins.jira.lucene.BaseLuceneExtensionLinkDataTest;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class EpicStoryLuceneExtensionLinkDataTest
extends BaseLuceneExtensionLinkDataTest {
    @Rule
    public final WiredIntegrationTestMethodRule wiredIntegrationTestRule = WiredTestRuleFactory.methodRule();
    @ClassRule
    public static final WiredIntegrationTestClassRule WIRED_INTEGRATION_TEST_CLASS_RULE = WiredTestRuleFactory.classRule();
    private final CustomFieldHelperBridgeProxy customFieldHelperBridgeProxy;
    private final AgileEpicLinkManagerServiceBridgeProxy agileEpicLinkManagerServiceBridgeProxy;

    @Autowired
    public EpicStoryLuceneExtensionLinkDataTest(IssueServiceBridgeProxy issueServiceBridgeVersionProxy, AgileCustomFieldsServiceBridgeProxy agileCustomFieldsServiceBridgeProxy, CustomFieldsService customFields, IssueTypeManager issueTypeManager, JiraAuthenticationContext authenticationContext, IssueService issueService, IssueIndexManager issueIndexManager, CustomFieldHelperBridgeProxy customFieldHelperBridgeProxy, AgileEpicLinkManagerServiceBridgeProxy agileEpicLinkManagerServiceBridgeProxy, WorklogService worklogService, WorkItemExtension workItemExtension) {
        super(issueServiceBridgeVersionProxy, agileCustomFieldsServiceBridgeProxy, customFields, issueTypeManager, authenticationContext, issueService, issueIndexManager, worklogService, workItemExtension);
        this.customFieldHelperBridgeProxy = customFieldHelperBridgeProxy;
        this.agileEpicLinkManagerServiceBridgeProxy = agileEpicLinkManagerServiceBridgeProxy;
    }

    @Test
    @AgileRequirements(installed=true)
    @JiraRequirements(maxVersionExclusive="7.0")
    @Login(user=User.ADMIN)
    @Projects(value={BaseLuceneExtensionLinkDataTest.LuceneExtensionTestProjectDefinitionScrum.class})
    public void testEpicStory() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(BaseLuceneExtensionLinkDataTest.LuceneExtensionTestProjectDefinitionScrum.class);
        ProgressConfiguration progressConfiguration = (ProgressConfiguration)Mockito.mock(ProgressConfiguration.class);
        Mockito.when((Object)progressConfiguration.getTrackerType()).thenReturn((Object)TrackerType.TimeBased);
        HashSet issueKeys = Sets.newHashSet();
        final AgileCustomFields customFields = ((AgileCustomFieldServiceBridge)this.agileCustomFieldsServiceBridgeProxy.get()).getCustomFields();
        List storyTypes = ((CustomFieldHelperBridge)this.customFieldHelperBridgeProxy.get()).getAssociatedIssueTypes(customFields.getStoryPointsField());
        List epicTypes = ((CustomFieldHelperBridge)this.customFieldHelperBridgeProxy.get()).getAssociatedIssueTypes(customFields.getEpicLabelField());
        for (IssueType epicType : epicTypes) {
            storyTypes.remove(epicType);
        }
        Issue epic = this.wiredIntegrationTestRule.getWiredTestUtils().getIssueUtils().createIssue(project, this.wiredIntegrationTestRule.getLoggedInUser(), ((IssueType)epicTypes.get(0)).getId(), 0L, new IssueInputCallback(){

            public void apply(IssueInputParameters inputParameters) {
                inputParameters.setSummary("Epic");
                inputParameters.addCustomFieldValue(customFields.getEpicLabelField().getIdAsLong(), new String[]{"Epic"});
            }
        });
        Issue story = this.wiredIntegrationTestRule.getWiredTestUtils().getIssueUtils().createIssue(project, this.wiredIntegrationTestRule.getLoggedInUser(), ((IssueType)storyTypes.get(0)).getId(), 240L, new IssueInputCallback(){

            public void apply(IssueInputParameters inputParameters) {
                inputParameters.setSummary("Story");
            }
        });
        ((AgileEpicLinkManagerServiceBridge)this.agileEpicLinkManagerServiceBridgeProxy.get()).associateIssueWithEpic(epic, story);
        this.createWorklog(story, "2h");
        this.issueIndexManager.reIndexAll();
        issueKeys.add(epic.getKey());
        MonitoredCallResult monitoredCallResult = this.workItemExtension.getExtensionLinkData(progressConfiguration, (Set)issueKeys);
        WorkItemExtensionLinkData data = (WorkItemExtensionLinkData)monitoredCallResult.getResult();
        Assert.assertEquals((double)data.getProgress(epic.getKey()).getDonePercentage(), (double)0.0, (double)1.0E-5);
        Assert.assertEquals((double)data.getFullProgress(epic.getKey()).getDonePercentage(), (double)0.5, (double)1.0E-5);
        Assert.assertFalse((boolean)data.getStatusData(epic.getKey()).isDone());
    }
}

