/*
 * Decompiled with CFR 0.152.
 */
package it.com.radiantminds.plugins.jira.testutils;

import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.rm.common.bridges.jira.scheme.SchemeEntityTypeUtilsBridge;
import com.atlassian.rm.common.bridges.jira.scheme.SchemeEntityTypeUtilsBridgeProxy;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="it.com.radiantminds.plugins.jira.testutils.PermissionUtils")
public class PermissionUtils {
    private final PermissionSchemeManager permissionSchemeManager;
    private final SchemeEntityTypeUtilsBridgeProxy schemeEntityTypeUtilsBridgeProxy;

    @Autowired
    public PermissionUtils(PermissionSchemeManager permissionSchemeManager, SchemeEntityTypeUtilsBridgeProxy schemeEntityTypeUtilsBridgeProxy) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.schemeEntityTypeUtilsBridgeProxy = schemeEntityTypeUtilsBridgeProxy;
    }

    public Scheme createRestrictedPermissionsScheme() {
        List<SchemeEntity> schemeEntities = this.getDefaultSchemeEntities();
        ((SchemeEntityTypeUtilsBridge)this.schemeEntityTypeUtilsBridgeProxy.get()).removeCreateIssuePermission(schemeEntities);
        ((SchemeEntityTypeUtilsBridge)this.schemeEntityTypeUtilsBridgeProxy.get()).addCreateIssuePermissionForDevelopers(schemeEntities);
        Scheme restrictedScheme = new Scheme(null, "PermissionScheme", "Restricted Scheme", "Restricted scheme that gives Create Issue permissions only to Developers.", schemeEntities);
        return this.permissionSchemeManager.createSchemeAndEntities(restrictedScheme);
    }

    public void deletePermissionsScheme(Scheme scheme) throws Exception {
        if (scheme != null) {
            this.permissionSchemeManager.deleteScheme(scheme.getId());
        }
    }

    public void addSchemeToProject(Project project, Scheme scheme) {
        this.permissionSchemeManager.removeSchemesFromProject(project);
        this.permissionSchemeManager.addSchemeToProject(project, scheme);
    }

    public void removeSchemesFromProject(Project project) throws Exception {
        if (project != null) {
            this.permissionSchemeManager.removeSchemesFromProject(project);
        }
    }

    private List<SchemeEntity> getDefaultSchemeEntities() {
        Scheme defaultScheme = this.permissionSchemeManager.getDefaultSchemeObject();
        Iterable defaultEntities = Iterables.transform((Iterable)defaultScheme.getEntities(), (Function)new Function<SchemeEntity, SchemeEntity>(){

            public SchemeEntity apply(SchemeEntity entity) {
                return new SchemeEntity(entity.getType(), entity.getParameter(), entity.getEntityTypeId());
            }
        });
        return Lists.newArrayList((Iterable)defaultEntities);
    }
}

