/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemStatus;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.OrderByHelper;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemTableHelper;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WorkItemsWithTypeQuery
implements IQuery<List<IWorkItem>> {
    private static final String ALIAS = "t";
    private final String planId;
    private final int type;
    private final boolean includeDone;
    private final List<String> aliases;

    private WorkItemsWithTypeQuery(String planId, int type, boolean includeDone, List<String> aliases) {
        this.planId = planId;
        this.type = type;
        this.includeDone = includeDone;
        this.aliases = aliases;
    }

    @Override
    public void sql(AOQueryGenerator generator) throws Exception {
        for (String workItemHierarchy : this.aliases) {
            generator.withTable(AOWorkItem.class, workItemHierarchy);
        }
        generator.select();
        generator.colId(this.aliases.get(0)).col(this.aliases.get(0), "title").col(this.aliases.get(0), "details");
        generator.col(this.aliases.get(this.aliases.size() - 1), "status");
        generator.from(this.aliases.get(0));
        for (int i = 1; i < this.aliases.size(); ++i) {
            WorkItemTableHelper.addJoin(this.aliases.get(i), this.aliases.get(i - 1), this.planId, generator);
        }
        generator.where().col(this.aliases.get(0), "type").eq().numeric(this.type).and().col(this.aliases.get(0), "aoPlan").eq().str(this.planId);
        if (!this.includeDone) {
            generator.and().col(this.aliases.get(0), "status").neq().numeric(WorkItemStatus.COMPLETED.value());
        }
        generator.orderBy();
        OrderByHelper.addOrderByClause(generator, this.aliases);
    }

    @Override
    public List<IWorkItem> handleResult(ResultSet result) throws Exception {
        ArrayList items = Lists.newArrayList();
        if (!result.isBeforeFirst()) {
            return items;
        }
        result.next();
        RestWorkItem pendingItem = this.createItem(result);
        items.add(pendingItem);
        while (result.next()) {
            String nextId = BaseAOPersistenceSQL.getString(result, 1);
            if (!nextId.equals(pendingItem.getId())) {
                pendingItem = this.createItem(result);
                items.add(pendingItem);
                continue;
            }
            Integer nextStatus = BaseAOPersistenceSQL.getInt(result, 4);
            if (!WorkItemStatus.OPEN.is(nextStatus)) continue;
            pendingItem.setStatus(WorkItemStatus.OPEN.value());
        }
        return items;
    }

    private RestWorkItem createItem(ResultSet result) throws SQLException {
        RestWorkItem pendingItem = new RestWorkItem(BaseAOPersistenceSQL.getString(result, 1), BaseAOPersistenceSQL.getString(result, 2), BaseAOPersistenceSQL.getString(result, 3));
        pendingItem.setStatus(BaseAOPersistenceSQL.getInt(result, 4));
        return pendingItem;
    }

    public static WorkItemsWithTypeQuery create(String planId, int type, boolean includeDone) {
        List<String> tableAliases = WorkItemsWithTypeQuery.createTableAliases(type);
        return new WorkItemsWithTypeQuery(planId, type, includeDone, tableAliases);
    }

    private static List<String> createTableAliases(int type) {
        ArrayList tableAliases = Lists.newArrayList();
        int levels = WorkItemsWithTypeQuery.getLevels(type);
        for (int i = 0; i < levels; ++i) {
            tableAliases.add(ALIAS + i);
        }
        return tableAliases;
    }

    private static int getLevels(int type) {
        if (type == WorkItems.Types.INITIATIVE) {
            return 3;
        }
        if (type == WorkItems.Types.EPIC) {
            return 2;
        }
        return 1;
    }
}

