/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.extensions;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.persistence.ao.AOEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.extensions.AOExtensionLink;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.extensions.sql.ExtensionLinkSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOStage;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IKeyResolver;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsExtensionLinkPersistence
extends AOEntityPersistence<IExtensionLink, AOExtensionLink>
implements PortfolioExtensionLinkPersistence {
    private final ExtensionLinkSQL extensionLinkSQL;

    @Autowired
    public PortfolioActiveObjectsExtensionLinkPersistence(ActiveObjectsUtilities utils) {
        super(utils, IExtensionLink.class, AOExtensionLink.class);
        this.extensionLinkSQL = new ExtensionLinkSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioExtensionLinkPersistence.class;
    }

    @Override
    protected void transform(IExtensionLink source, AOExtensionLink target) throws Exception {
        TransformerUtils.transformVersionable(source, target);
        target.setExtensionKey(source.getExtensionKey());
        target.setExtensionLink(source.getExtensionLink());
        target.setExtendable(source.getExtendable());
    }

    @Override
    public EntityInfo getEntityInfo(String id) throws SQLException {
        return this.extensionLinkSQL.getEntityInfo(id);
    }

    @Override
    public void addExtensionLink(Class<?> extendableClazz, String extendableId, String key, String link) throws SQLException {
        this.extensionLinkSQL.add(extendableClazz, extendableId, key, link);
    }

    @Override
    public void removeExtensionLink(Class<?> extendableClazz, String extendableId, String key, String link) throws SQLException {
        this.extensionLinkSQL.delete(extendableClazz, extendableId, key, link);
    }

    @Override
    public List<String> getTargetIdsForLink(Class<?> extendableClazz, String key, String link) throws SQLException {
        return this.extensionLinkSQL.getTargetIdsForLink(extendableClazz, key, link);
    }

    @Override
    public List<IExtensionLink> getLinksForTarget(Class<?> extendableClazz, String extendableId) throws SQLException {
        return this.extensionLinkSQL.getLinksForTarget(extendableClazz, extendableId);
    }

    @Override
    public void removeAllExtensionLinks(String key, String link) throws SQLException {
        this.extensionLinkSQL.removeAllExtensionLinks(key, link);
    }

    @Override
    public void removeAllExtensionLinksWithKey(Class<?> extendableClazz, String key) throws SQLException {
        this.extensionLinkSQL.removeAllExtensionLinksWithKey(extendableClazz, key);
    }

    @Override
    public void removeAllExtensionLinksWhereKeyLike(Class<?> extendableClazz, String extendableId, String keyLike, String ... unlessKeyLike) throws SQLException {
        this.extensionLinkSQL.removeAllExtensionLinksWhereKeyLike(extendableClazz, extendableId, keyLike, unlessKeyLike);
    }

    @Override
    public void removeAllExtensionLinksWhereValueStartsWith(Class<?> extendableClazz, String extendableId, String key, String projectPrefix) throws SQLException {
        this.extensionLinkSQL.removeAllExtensionLinksWhereValueStartsWith(extendableClazz, extendableId, key, projectPrefix);
    }

    @Override
    public Set<String> getLinksForPlan(String planId) throws SQLException {
        return this.extensionLinkSQL.getExtensionLinksForPlan(planId);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOExtensionLink.class, "e").withTable(AOWorkItem.class, "w").withTable(AORelease.class, "r").withTable(AOStream.class, "s").select().raw("e.*").from("e").leftJoin().table("w").on().colPolyType("e", "aoExtendable").eq().str(AOWorkItem.class.getName()).and().col("e", "aoExtendable").eq().colId("w").leftJoin().table("r").on().colPolyType("e", "aoExtendable").eq().str(AORelease.class.getName()).and().col("e", "aoExtendable").eq().colId("r").leftJoin().table("s").on().colId("s").eq().col("r", "aoStream").where().col("w", "aoplan").eq().numeric(planId).or().col("s", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().colId("e");
        }
    }

    @Override
    public IKeyResolver getForeignKeyResolver(String method) {
        if ("getAOExtendable".equals(method)) {
            return new ExtensionLinkForeignKeyResolver();
        }
        if ("getExtensionKey".equals(method)) {
            return new ExtensionLinkKeyForeignKeyResolver();
        }
        return super.getForeignKeyResolver(method);
    }

    private class ExtensionLinkForeignKeyResolver
    implements IKeyResolver {
        private ExtensionLinkForeignKeyResolver() {
        }

        @Override
        public Class<?> resolve(String dependency) {
            if (AOWorkItem.class.getName().equals(dependency)) {
                return AOWorkItem.class;
            }
            if (AORelease.class.getName().equals(dependency)) {
                return AORelease.class;
            }
            throw new RuntimeException("Cannot create foreign key resolver for extension link type '" + dependency + "'.");
        }

        @Override
        public String getPrefix(String dependency) {
            return null;
        }
    }

    private class ExtensionLinkKeyForeignKeyResolver
    implements IKeyResolver {
        private ExtensionLinkKeyForeignKeyResolver() {
        }

        @Override
        public Class<?> resolve(String dependency) {
            if (dependency.startsWith("jira-issue-stage-")) {
                return AOStage.class;
            }
            return null;
        }

        @Override
        public String getPrefix(String dependency) {
            if (dependency != null && dependency.startsWith("jira-issue-stage-")) {
                return "jira-issue-stage-";
            }
            return "";
        }
    }
}

