/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.AONonWorkingDays;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.rest.entities.plans.RestNonWorkingDay;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class NonWorkingDaysSQL
extends BaseAOPersistenceSQL {
    public NonWorkingDaysSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public List<RestNonWorkingDay> listForPlan(final String planId) throws SQLException {
        return this.sql(new IQuery<List<RestNonWorkingDay>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AONonWorkingDays.class, "i").select().colId("i").col("i", "title").col("i", "description").col("i", "version").col("i", "startDate").col("i", "endDate").col("i", "sortOrder").from("i").where().col("i", "aoPlan").eq().numeric(planId).orderBy().col("i", "sortOrder");
            }

            @Override
            public List<RestNonWorkingDay> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    RestNonWorkingDay interval = new RestNonWorkingDay(BaseAOPersistenceSQL.getString(result, 1), BaseAOPersistenceSQL.getString(result, 2), BaseAOPersistenceSQL.getString(result, 3));
                    interval.setVersion(NonWorkingDaysSQL.getLong(result, 4));
                    interval.setStartDate(NonWorkingDaysSQL.getLong(result, 5));
                    interval.setEndDate(NonWorkingDaysSQL.getLong(result, 6));
                    interval.setSortOrder(NonWorkingDaysSQL.getLong(result, 7));
                    retVal.add(interval);
                }
                return retVal;
            }
        });
    }
}

