/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals.AOAvailability;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.rest.entities.people.RestAvailability;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class AvailabilityIntervalSQL
extends BaseAOPersistenceSQL {
    public AvailabilityIntervalSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public List<RestAvailability> listForResource(final String resourceId) throws SQLException {
        return this.sql(new IQuery<List<RestAvailability>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOAvailability.class, "i").select().colId("i").col("i", "title").col("i", "description").col("i", "availability").col("i", "version").col("i", "startDate").col("i", "endDate").col("i", "sortOrder").from("i").where().col("i", "aoResource").eq().numeric(resourceId).orderBy().col("i", "sortOrder");
            }

            @Override
            public List<RestAvailability> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    RestAvailability interval = new RestAvailability(BaseAOPersistenceSQL.getString(result, 1), BaseAOPersistenceSQL.getString(result, 2), BaseAOPersistenceSQL.getString(result, 3), BaseAOPersistenceSQL.getDouble(result, 4));
                    interval.setVersion(AvailabilityIntervalSQL.getLong(result, 5));
                    interval.setStartDate(AvailabilityIntervalSQL.getLong(result, 6));
                    interval.setEndDate(AvailabilityIntervalSQL.getLong(result, 7));
                    interval.setSortOrder(AvailabilityIntervalSQL.getLong(result, 8));
                    retVal.add(interval);
                }
                return retVal;
            }
        });
    }
}

