/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jmx;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.javasimon.Manager;
import org.javasimon.SimonException;
import org.javasimon.SimonManager;
import org.javasimon.jmx.JmxRegisterCallback;
import org.javasimon.jmx.SimonManagerMXBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmxReporter {
    public static final String DEFAULT_BEAN_NAME = "org.javasimon.jmx.JmxReporter:type=Simon";
    public static final String DEFAULT_SIMON_DOMAIN = "org.javasimon.jmx.simons";
    private static final Logger logger = LoggerFactory.getLogger(JmxReporter.class);
    private final Manager manager;
    private MBeanServer beanServer;
    private String beanName;
    private boolean replaceExistingMxBeans;
    private boolean registerSimons;
    private boolean registerExistingSimons;
    private String simonDomain;
    private JmxRegisterCallback jmxRegisterCallback;

    private JmxReporter(Manager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Manager is null");
        }
        this.manager = manager;
    }

    public static JmxReporter forManager(Manager manager) {
        JmxReporter reporter = new JmxReporter(manager);
        reporter.setBeanName(DEFAULT_BEAN_NAME);
        reporter.simonDomain = DEFAULT_SIMON_DOMAIN;
        reporter.beanServer = ManagementFactory.getPlatformMBeanServer();
        return reporter;
    }

    public static JmxReporter forDefaultManager() {
        return JmxReporter.forManager(SimonManager.manager());
    }

    public JmxReporter simonDomain(String simonDomain) {
        this.setSimonDomain(simonDomain);
        return this;
    }

    public JmxReporter replaceExisting() {
        this.replaceExistingMxBeans = true;
        return this;
    }

    public JmxReporter registerSimons() {
        this.registerSimons = true;
        return this;
    }

    public JmxReporter registerExistingSimons() {
        this.registerExistingSimons = true;
        return this;
    }

    public JmxReporter beanName(String beanName) {
        this.setBeanName(beanName);
        return this;
    }

    JmxReporter beanServer(MBeanServer beanServer) {
        this.setBeanServer(beanServer);
        return this;
    }

    private void setBeanName(String beanName) {
        if (beanName == null || beanName.isEmpty()) {
            throw new IllegalArgumentException("Bean name is null or empty");
        }
        this.beanName = beanName;
    }

    public Manager getManager() {
        return this.manager;
    }

    public MBeanServer getBeanServer() {
        return this.beanServer;
    }

    public void setBeanServer(MBeanServer beanServer) {
        this.beanServer = beanServer;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getSimonDomain() {
        return this.simonDomain;
    }

    public void setSimonDomain(String simonDomain) {
        if (simonDomain == null || simonDomain.isEmpty()) {
            throw new IllegalArgumentException("Simon domain is null or empty");
        }
        this.simonDomain = simonDomain;
    }

    public boolean isReplaceExistingMxBeans() {
        return this.replaceExistingMxBeans;
    }

    public void setReplaceExistingMxBeans(boolean replaceExistingMxBeans) {
        this.replaceExistingMxBeans = replaceExistingMxBeans;
    }

    public boolean isRegisterSimons() {
        return this.registerSimons;
    }

    public void setRegisterSimons(boolean registerSimons) {
        this.registerSimons = registerSimons;
    }

    public boolean isRegisterExistingSimons() {
        return this.registerExistingSimons;
    }

    public void setRegisterExistingSimons(boolean registerExistingSimons) {
        this.registerExistingSimons = registerExistingSimons;
    }

    public JmxReporter start() {
        SimonManagerMXBeanImpl simonManagerMXBean = new SimonManagerMXBeanImpl(this.manager);
        this.registerMXBean(simonManagerMXBean, this.beanName);
        if (this.registerSimons) {
            this.jmxRegisterCallback = new JmxRegisterCallback(this.beanServer, this.simonDomain);
            if (this.registerExistingSimons) {
                this.jmxRegisterCallback.setRegisterExisting(true);
            }
            this.manager.callback().addCallback(this.jmxRegisterCallback);
        }
        return this;
    }

    private void registerMXBean(Object bean, String newBeanName) {
        try {
            ObjectName beanObjectName = new ObjectName(newBeanName);
            if (this.replaceExistingMxBeans && this.beanServer.isRegistered(beanObjectName)) {
                logger.warn("Replacing existing SimonManager JMX bean");
                this.beanServer.unregisterMBean(beanObjectName);
            }
            logger.info("Registering new SimonManager JMX bean with name {}", (Object)newBeanName);
            this.beanServer.registerMBean(bean, beanObjectName);
        }
        catch (JMException e) {
            throw new SimonException("Failed to register Jmx reporter", e);
        }
    }

    public void stop() {
        this.unregisterManagerBean();
        this.unregisterSimonBeans();
    }

    private void unregisterManagerBean() {
        try {
            ObjectName beanObjectName = new ObjectName(this.beanName);
            if (this.beanServer.isRegistered(beanObjectName)) {
                this.beanServer.unregisterMBean(beanObjectName);
            } else {
                logger.warn("SimonManager JMX bean with name {} was not registered", (Object)this.beanName);
            }
        }
        catch (JMException e) {
            throw new SimonException("Failed to unregister SimonManager MX bean", e);
        }
    }

    private void unregisterSimonBeans() {
        if (this.jmxRegisterCallback != null) {
            this.manager.callback().removeCallback(this.jmxRegisterCallback);
        }
    }
}

