/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class GroupAssignmentRestriction
implements AssignmentRestriction {
    private final AssignmentRestriction parentRestriction;
    private final Set<String> availableGroups;

    public GroupAssignmentRestriction(AssignmentRestriction parentRestriction, Set<String> availableGroups) {
        this.parentRestriction = parentRestriction;
        this.availableGroups = availableGroups;
    }

    @Override
    public Set<IMutableResourcePool> filterMutableResourcePools(Set<IMutableResourceGroup> mutableResourceGroups) {
        HashSet filtered = Sets.newHashSet();
        for (IMutableResourcePool element : this.parentRestriction.filterMutableResourcePools(mutableResourceGroups)) {
            if (!this.availableGroups.contains(element.getId())) continue;
            filtered.add(element);
        }
        return filtered;
    }

    @Override
    public Set<IResourcePool> getResourcePools() {
        HashSet filtered = Sets.newHashSet();
        for (IResourcePool element : this.parentRestriction.getResourcePools()) {
            if (!this.availableGroups.contains(element.getId())) continue;
            filtered.add(element);
        }
        return filtered;
    }

    @Override
    public Optional<Integer> getWorkSlotIndex() {
        return this.parentRestriction.getWorkSlotIndex();
    }

    @Override
    public Set<String> getResourceGroupIds() {
        return Sets.intersection(this.parentRestriction.getResourceGroupIds(), this.availableGroups);
    }

    @Override
    public Optional<AssignmentRestriction> getStageTaskResourceRestriction(String stageTaskId) {
        return Optional.absent();
    }

    @Override
    public Set<String> getStageTaskIds() {
        return Collections.emptySet();
    }

    @Override
    public Set<AssignmentResource> filterResources(Set<AssignmentResource> skillRelevantResources) {
        Set<String> ids = RmIdentifiableUtils.getIds(this.getResources());
        return RmIdentifiableUtils.getElementsWithIds(ids, skillRelevantResources);
    }

    @Override
    public Set<IWorkResource> getResources() {
        HashSet filtered = Sets.newHashSet();
        for (IWorkResource element : this.parentRestriction.getResources()) {
            if (!this.availableGroups.contains(element.getGroupId())) continue;
            filtered.add(element);
        }
        return filtered;
    }
}

