/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.SearchResults;
import com.mysema.query.Tuple;
import com.mysema.query.sql.AbstractSQLQuery;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.ForeignKey;
import com.mysema.query.sql.RelationalFunctionCall;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLBindings;
import com.mysema.query.sql.SQLCommonQuery;
import com.mysema.query.sql.SQLOps;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.Union;
import com.mysema.query.sql.UnionImpl;
import com.mysema.query.sql.UnionUtils;
import com.mysema.query.sql.WithBuilder;
import com.mysema.query.support.Expressions;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.ParamNotSetException;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathExtractor;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.Wildcard;
import com.mysema.query.types.query.ListSubQuery;
import com.mysema.query.types.template.NumberTemplate;
import com.mysema.query.types.template.SimpleTemplate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@BridgeMethodsAdded
public abstract class ProjectableSQLQuery<Q extends ProjectableSQLQuery<Q>>
extends ProjectableQuery<Q>
implements SQLCommonQuery<Q> {
    private static final Path<?> defaultQueryAlias = new PathImpl<Object>(Object.class, "query");
    protected final Configuration configuration;
    @Nullable
    protected Expression<?> union;
    private SubQueryExpression<?> firstUnionSubQuery;
    protected boolean unionAll;

    public ProjectableSQLQuery(QueryMixin<Q> queryMixin, Configuration configuration) {
        super(queryMixin);
        this.queryMixin.setSelf(this);
        this.configuration = configuration;
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q addJoinFlag(String flag) {
        return (Q)this.addJoinFlag(flag, JoinFlag.Position.BEFORE_TARGET);
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q addJoinFlag(String flag, JoinFlag.Position position) {
        this.queryMixin.addJoinFlag(new JoinFlag(flag, position));
        return (Q)this;
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q addFlag(QueryFlag.Position position, String prefix, Expression<?> expr) {
        SimpleExpression<?> flag = SimpleTemplate.create(expr.getType(), prefix + "{0}", expr);
        return (Q)((ProjectableSQLQuery)this.queryMixin.addFlag(new QueryFlag(position, flag)));
    }

    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q addFlag(QueryFlag flag) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.addFlag(flag));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q addFlag(QueryFlag.Position position, String flag) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.addFlag(new QueryFlag(position, flag)));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q addFlag(QueryFlag.Position position, Expression<?> flag) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.addFlag(new QueryFlag(position, flag)));
    }

    @Override
    public long count() {
        Number number = this.uniqueResult((Expression)Wildcard.countAsInt);
        return number.longValue();
    }

    @Override
    public boolean exists() {
        return ((ProjectableSQLQuery)this.limit(1L)).singleResult(NumberTemplate.ONE) != null;
    }

    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q from(Expression<?> arg) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.from(arg));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q from(Expression<?> ... args) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.from(args));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q from(SubQueryExpression<?> subQuery, Path<?> alias) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.from(ExpressionUtils.as(subQuery, alias)));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q fullJoin(EntityPath<?> target) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.fullJoin(target));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <E> Q fullJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.fullJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q fullJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.fullJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <E> Q fullJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((ProjectableSQLQuery)this.queryMixin.fullJoin(entity)).on(key.on(entity));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q innerJoin(EntityPath<?> target) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.innerJoin(target));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <E> Q innerJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.innerJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q innerJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.innerJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <E> Q innerJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((ProjectableSQLQuery)this.queryMixin.innerJoin(entity)).on(key.on(entity));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q join(EntityPath<?> target) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.join(target));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <E> Q join(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.join(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q join(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.join(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <E> Q join(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((ProjectableSQLQuery)this.queryMixin.join(entity)).on(key.on(entity));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q leftJoin(EntityPath<?> target) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.leftJoin(target));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <E> Q leftJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.leftJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q leftJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.leftJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <E> Q leftJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((ProjectableSQLQuery)this.queryMixin.leftJoin(entity)).on(key.on(entity));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q rightJoin(EntityPath<?> target) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.rightJoin(target));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <E> Q rightJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.rightJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q rightJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.rightJoin(target, alias));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <E> Q rightJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((ProjectableSQLQuery)this.queryMixin.rightJoin(entity)).on(key.on(entity));
    }

    public QueryMetadata getMetadata() {
        return this.queryMixin.getMetadata();
    }

    private <RT> Union<RT> innerUnion(SubQueryExpression<?> ... sq) {
        this.queryMixin.getMetadata().setValidate(false);
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("Don't mix union and from");
        }
        this.union = UnionUtils.union(sq, this.unionAll);
        this.firstUnionSubQuery = sq[0];
        return new UnionImpl(this, sq[0].getMetadata().getProjection());
    }

    @Override
    public CloseableIterator<Tuple> iterate(Expression<?> ... args) {
        return this.iterate(this.queryMixin.createProjection(args));
    }

    @Override
    public List<Tuple> list(Expression<?> ... args) {
        return this.list(this.queryMixin.createProjection(args));
    }

    @Override
    public SearchResults<Tuple> listResults(Expression<?> ... args) {
        return this.listResults(this.queryMixin.createProjection(args));
    }

    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q on(Predicate condition) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.on(condition));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q on(Predicate ... conditions) {
        return (Q)((ProjectableSQLQuery)this.queryMixin.on(conditions));
    }

    public <RT> Union<RT> union(ListSubQuery<RT> ... sq) {
        return this.innerUnion(sq);
    }

    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <RT> Q union(Path<?> alias, ListSubQuery<RT> ... sq) {
        return this.from(UnionUtils.union(sq, alias, false));
    }

    public <RT> Union<RT> union(SubQueryExpression<RT> ... sq) {
        return this.innerUnion(sq);
    }

    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <RT> Q union(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return this.from(UnionUtils.union(sq, alias, false));
    }

    public <RT> Union<RT> unionAll(ListSubQuery<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion(sq);
    }

    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <RT> Q unionAll(Path<?> alias, ListSubQuery<RT> ... sq) {
        return this.from(UnionUtils.union(sq, alias, true));
    }

    public <RT> Union<RT> unionAll(SubQueryExpression<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion(sq);
    }

    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public <RT> Q unionAll(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return this.from(UnionUtils.union(sq, alias, true));
    }

    @Override
    public Tuple uniqueResult(Expression<?> ... args) {
        return this.uniqueResult((Expression)this.queryMixin.createProjection(args));
    }

    @Override
    public <RT> RT uniqueResult(Expression<RT> expr) {
        if (this.getMetadata().getModifiers().getLimit() == null && !expr.toString().contains("count(")) {
            this.limit(2L);
        }
        CloseableIterator<RT> iterator = this.iterate(expr);
        return ((ProjectableQuery)this).uniqueResult(iterator);
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q withRecursive(Path<?> alias, SubQueryExpression<?> query) {
        this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, SQLTemplates.RECURSIVE));
        return (Q)this.with((Path)alias, (SubQueryExpression)query);
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q withRecursive(Path<?> alias, Expression<?> query) {
        this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, SQLTemplates.RECURSIVE));
        return (Q)this.with((Path)alias, (Expression)query);
    }

    @Override
    public WithBuilder<Q> withRecursive(Path<?> alias, Path<?> ... columns) {
        this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, SQLTemplates.RECURSIVE));
        return this.with(alias, columns);
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q with(Path<?> alias, SubQueryExpression<?> query) {
        Operation<Object> expr = OperationImpl.create(alias.getType(), SQLOps.WITH_ALIAS, alias, query);
        return (Q)((ProjectableSQLQuery)this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, expr)));
    }

    @Override
    @WithBridgeMethods(value={AbstractSQLQuery.class}, castRequired=true)
    public Q with(Path<?> alias, Expression<?> query) {
        Operation<Object> expr = OperationImpl.create(alias.getType(), SQLOps.WITH_ALIAS, alias, query);
        return (Q)((ProjectableSQLQuery)this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, expr)));
    }

    @Override
    public WithBuilder<Q> with(Path<?> alias, Path<?> ... columns) {
        Expression<Object> columnsCombined = ExpressionUtils.list(Object.class, columns);
        SimpleExpression<Object> aliasCombined = Expressions.operation(alias.getType(), SQLOps.WITH_COLUMNS, alias, columnsCombined);
        return new WithBuilder(this.queryMixin, aliasCombined);
    }

    protected void clone(Q query) {
        this.union = ((ProjectableSQLQuery)query).union;
        this.unionAll = ((ProjectableSQLQuery)query).unionAll;
    }

    public abstract Q clone();

    protected abstract SQLSerializer createSerializer();

    private Set<Path<?>> getRootPaths(Collection<Expression<?>> exprs) {
        HashSet paths = Sets.newHashSet();
        for (Expression<?> e : exprs) {
            Path path = (Path)e.accept(PathExtractor.DEFAULT, null);
            if (path == null || path.getMetadata().isRoot()) continue;
            paths.add(path.getMetadata().getRoot());
        }
        return paths;
    }

    private Collection<Expression<?>> expandProjection(Collection<Expression<?>> exprs) {
        if (exprs.size() == 1 && exprs.iterator().next() instanceof FactoryExpression) {
            return ((FactoryExpression)exprs.iterator().next()).getArgs();
        }
        return exprs;
    }

    protected SQLSerializer serialize(boolean forCountRow) {
        SQLSerializer serializer = this.createSerializer();
        if (this.union != null) {
            if (this.queryMixin.getMetadata().getProjection().isEmpty() || this.expandProjection(this.queryMixin.getMetadata().getProjection()).equals(this.expandProjection(this.firstUnionSubQuery.getMetadata().getProjection()))) {
                serializer.serializeUnion(this.union, this.queryMixin.getMetadata(), this.unionAll);
            } else {
                QueryMixin mixin2 = new QueryMixin(this.queryMixin.getMetadata().clone());
                Set<Path<?>> paths = this.getRootPaths(this.expandProjection(mixin2.getMetadata().getProjection()));
                if (paths.isEmpty()) {
                    mixin2.from(ExpressionUtils.as(this.union, defaultQueryAlias));
                } else if (paths.size() == 1) {
                    mixin2.from(ExpressionUtils.as(this.union, paths.iterator().next()));
                } else {
                    throw new IllegalStateException("Unable to create serialize union");
                }
                serializer.serialize(mixin2.getMetadata(), forCountRow);
            }
        } else {
            serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        }
        return serializer;
    }

    public SQLBindings getSQL(Expression<?> ... exprs) {
        this.queryMixin.addProjection(exprs);
        SQLSerializer serializer = this.serialize(false);
        ImmutableList.Builder args = ImmutableList.builder();
        Map<ParamExpression<?>, Object> params = this.getMetadata().getParams();
        for (Object o : serializer.getConstants()) {
            if (o instanceof ParamExpression) {
                if (!params.containsKey(o)) {
                    throw new ParamNotSetException((ParamExpression)o);
                }
                o = this.queryMixin.getMetadata().getParams().get(o);
            }
            args.add(o);
        }
        return new SQLBindings(serializer.toString(), (ImmutableList<Object>)args.build());
    }

    @Override
    public String toString() {
        SQLSerializer serializer = this.serialize(false);
        return serializer.toString().trim();
    }
}

