/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.issues.sync;

import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;

public abstract class BaseSyncHandler {
    private static final Log LOGGER = Log.with(BaseSyncHandler.class);

    protected static boolean isSyncEnabledForWorkItem(IPlanConfiguration planConfiguration, IWorkItem workItem) {
        Integer workItemType = workItem.getType();
        if (WorkItems.Types.INITIATIVE.equals(workItemType)) {
            return planConfiguration.getSyncInitiatives();
        }
        if (WorkItems.Types.EPIC.equals(workItemType)) {
            return planConfiguration.getSyncEpics();
        }
        if (WorkItems.Types.STORY.equals(workItemType)) {
            return planConfiguration.getSyncStories();
        }
        LOGGER.info("Unknown work item type for syncing ('" + workItemType + "'). Syncing disabled for this item.", new Object[0]);
        return false;
    }
}

