/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.entities.workitems;

import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;

public enum WorkItemType {
    Initiative(false),
    Epic(true),
    Story(true);

    private final boolean canHaveParent;

    private WorkItemType(boolean canHaveParent) {
        this.canHaveParent = canHaveParent;
    }

    public boolean canHaveParent() {
        return this.canHaveParent;
    }

    public static WorkItemType fromCode(Integer type) {
        Preconditions.checkNotNull((Object)type);
        if (WorkItems.Types.INITIATIVE.equals(type)) {
            return Initiative;
        }
        if (WorkItems.Types.EPIC.equals(type)) {
            return Epic;
        }
        if (WorkItems.Types.STORY.equals(type)) {
            return Story;
        }
        throw new IllegalArgumentException("no work item type code");
    }
}

