/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.MutableAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.UnstructuredItemState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IUnstructuredItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.UnstructuredItem;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UnstructuredItemTrackerImpl
implements UnstructuredItemState {
    private final Map<String, MutableAggregatedWorkPackage> openUnstructuredWork;
    private final Set<String> splitUnstructuredItemIds = Sets.newHashSet();

    UnstructuredItemTrackerImpl(Map<String, MutableAggregatedWorkPackage> openUnstructuredWork) {
        this.openUnstructuredWork = openUnstructuredWork;
    }

    @Override
    public boolean isSplitItem(String itemId) {
        return this.splitUnstructuredItemIds.contains(itemId);
    }

    @Override
    public Optional<IUnstructuredItem> tryGetRemaining(IUnstructuredItemSchedule schedule, IProcessingItem processingItem) {
        MutableAggregatedWorkPackage openWork = this.getDecreased(schedule);
        if (!openWork.isEmpty() && !schedule.isItemCompleted()) {
            this.splitUnstructuredItemIds.add(processingItem.getId());
            UnstructuredItem newItem = new UnstructuredItem(processingItem.getId(), (String)processingItem.getTitle().orNull(), processingItem.getPriority(), schedule.getEnd(), openWork.toImmutable(), processingItem.getAssignmentRestriction(), processingItem, processingItem.getSortKey());
            return Optional.of((Object)newItem);
        }
        return Optional.absent();
    }

    private MutableAggregatedWorkPackage getDecreased(IUnstructuredItemSchedule schedule) {
        MutableAggregatedWorkPackage openWork = this.openUnstructuredWork.get(schedule.getId());
        openWork.decrease(schedule.getAggregatedWorkPackage());
        return openWork;
    }

    public static UnstructuredItemState createInstance(Collection<IUnstructuredItem> unstructuredItems) {
        return new UnstructuredItemTrackerImpl(UnstructuredItemTrackerImpl.getMutableWorkPackages(unstructuredItems));
    }

    private static Map<String, MutableAggregatedWorkPackage> getMutableWorkPackages(Collection<IUnstructuredItem> unstructuredItems) {
        HashMap packageMap = Maps.newHashMap();
        for (IUnstructuredItem item : unstructuredItems) {
            packageMap.put(item.getId(), MutableAggregatedWorkPackage.createInstance(item.getWorkDemand()));
        }
        return packageMap;
    }
}

