/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.entities.transferables;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingAvailability;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferableAvailability;
import java.util.List;

public class TransferableResource
implements SchedulingResource {
    private Double availability;
    private String personId;
    private List<TransferableAvailability> availabilityIntervals;
    private String id;
    private Long sortOrder;

    TransferableResource(SchedulingResource resource) {
        this.id = resource.getId();
        this.sortOrder = resource.getSortOrder();
        this.availability = resource.getAvailability();
        this.personId = resource.getPersonId();
        this.availabilityIntervals = Lists.newArrayList();
        for (SchedulingAvailability schedulingAvailability : resource.getAvailabilityIntervals()) {
            this.availabilityIntervals.add(new TransferableAvailability(schedulingAvailability));
        }
    }

    @Override
    public Double getAvailability() {
        return this.availability;
    }

    @Override
    public String getPersonId() {
        return this.personId;
    }

    @Override
    public List<? extends SchedulingAvailability> getAvailabilityIntervals() {
        return this.availabilityIntervals;
    }

    @Override
    public Long getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

