/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep.IDependencyDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class GraphBasedDependencyDefinition
implements IDependencyDefinition {
    private static final Log LOGGER = Log.with(GraphBasedDependencyDefinition.class);
    private final DirectedAcyclicGraph<IProcessingItem, DefaultEdge> dependencyGraph;
    private final SimpleDirectedGraph<IProcessingItem, DefaultEdge> transitiveClosure;

    public GraphBasedDependencyDefinition(DirectedAcyclicGraph<IProcessingItem, DefaultEdge> dependencyGraph) {
        this.dependencyGraph = (DirectedAcyclicGraph)Preconditions.checkNotNull(dependencyGraph);
        this.transitiveClosure = GraphBasedDependencyDefinition.createTransitiveClosure(dependencyGraph);
    }

    @Override
    public Set<IProcessingItem> getProcessingItems() {
        return this.dependencyGraph.vertexSet();
    }

    @Override
    public Set<IProcessingItem> getDirectDependees(IProcessingItem item) {
        HashSet dependents = Sets.newHashSetWithExpectedSize((int)this.dependencyGraph.outDegreeOf(item));
        for (DefaultEdge edge : this.dependencyGraph.outgoingEdgesOf(item)) {
            dependents.add(this.dependencyGraph.getEdgeTarget(edge));
        }
        return dependents;
    }

    @Override
    public Set<IProcessingItem> getDirectPrerequisites(IProcessingItem item) {
        HashSet prerequisites = Sets.newHashSetWithExpectedSize((int)this.dependencyGraph.outDegreeOf(item));
        for (DefaultEdge edge : this.dependencyGraph.incomingEdgesOf(item)) {
            prerequisites.add(this.dependencyGraph.getEdgeSource(edge));
        }
        return prerequisites;
    }

    @Override
    public Set<IProcessingItem> getTransitivePrerequisites(IProcessingItem item) {
        return Sets.newHashSet(Graphs.predecessorListOf(this.transitiveClosure, item));
    }

    @Override
    public Set<IProcessingItem> getTransitiveDependents(IProcessingItem item) {
        return Sets.newHashSet(Graphs.successorListOf(this.transitiveClosure, item));
    }

    private static SimpleDirectedGraph<IProcessingItem, DefaultEdge> createTransitiveClosure(DirectedAcyclicGraph<IProcessingItem, DefaultEdge> dependencyGraph) {
        LOGGER.debug("calculate transitive closure", new Object[0]);
        SimpleDirectedGraph<IProcessingItem, DefaultEdge> closure = new SimpleDirectedGraph<IProcessingItem, DefaultEdge>(DefaultEdge.class);
        Graphs.addAllVertices(closure, dependencyGraph.vertexSet());
        List<IProcessingItem> orderedItems = GraphBasedDependencyDefinition.getTopologicallyOrderedVertices(dependencyGraph);
        for (int i = 0; i < orderedItems.size(); ++i) {
            IProcessingItem next = orderedItems.get(orderedItems.size() - 1 - i);
            for (IProcessingItem successor : Graphs.successorListOf(dependencyGraph, next)) {
                Graphs.addEdgeWithVertices(closure, next, successor);
                for (IProcessingItem closureItem : Graphs.successorListOf(closure, successor)) {
                    Graphs.addEdgeWithVertices(closure, next, closureItem);
                }
            }
        }
        LOGGER.debug("calculated transitive closure", new Object[0]);
        return closure;
    }

    private static List<IProcessingItem> getTopologicallyOrderedVertices(DirectedGraph<IProcessingItem, DefaultEdge> dependencyGraph) {
        TopologicalOrderIterator<IProcessingItem, DefaultEdge> iterator = new TopologicalOrderIterator<IProcessingItem, DefaultEdge>(dependencyGraph);
        ArrayList orderedItems = Lists.newArrayList();
        while (iterator.hasNext()) {
            orderedItems.add(iterator.next());
        }
        return orderedItems;
    }
}

