/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.plugins.jira.conditions.ConfigurablePluginAccessPermissionsProvider;
import com.radiantminds.roadmap.api.PluginPermission;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.jira.common.components.init.LaunchStateService;
import java.util.Map;
import java.util.Set;

public class ConfigurablePluginAccessCondition
implements Condition {
    private static final String PERMISSIONS_PARAM = "permissions";
    private static final Log LOGGER = Log.with(ConfigurablePluginAccessCondition.class);
    private final PluginPermissions pluginPermissionHandler;
    private final LaunchStateService launchStateService;
    private PluginPermission[] pluginPermissions;

    public ConfigurablePluginAccessCondition(PluginPermissions pluginPermissionHandler, LaunchStateService launchStateService) {
        this.pluginPermissionHandler = pluginPermissionHandler;
        this.launchStateService = launchStateService;
    }

    public void init(Map<String, String> map) throws PluginParseException {
        String config = map.get(PERMISSIONS_PARAM);
        if (config == null) {
            throw this.createNoConfigurationException();
        }
        String trimmedConfig = config.trim();
        if (trimmedConfig.length() == 0) {
            throw this.createNoConfigurationException();
        }
        Set<PluginPermission> pluginPermissionsSet = ConfigurablePluginAccessPermissionsProvider.parse(trimmedConfig);
        this.pluginPermissions = pluginPermissionsSet.toArray(new PluginPermission[pluginPermissionsSet.size()]);
    }

    private PluginParseException createNoConfigurationException() {
        return new PluginParseException(String.format("Required parameter '%s' not present.", PERMISSIONS_PARAM));
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        if (!this.launchStateService.isLaunched()) {
            return false;
        }
        try {
            return this.pluginPermissionHandler.checkOr(this.pluginPermissions);
        }
        catch (Exception e) {
            LOGGER.exception(e, Log.LogLevel.WARN);
            return false;
        }
    }
}

