/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.permissions;

import com.radiantminds.roadmap.common.data.entities.permissions.IPermission;
import com.radiantminds.roadmap.common.rest.entities.common.BaseRestEntity;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="permission")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestPermission
extends BaseRestEntity
implements IPermission {
    @XmlElement
    private String targetType;
    @XmlElement
    private String targetId;
    @XmlElement
    private String holderType;
    @XmlElement
    private String holderId;
    @XmlElement
    private Integer permission;
    @XmlElement
    private String displayName;

    @Override
    public String getTargetType() {
        return this.targetType;
    }

    @Override
    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }

    @Override
    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @Override
    public String getHolderType() {
        return this.holderType;
    }

    @Override
    public void setHolderType(String holderType) {
        this.holderType = holderType;
    }

    @Override
    public String getHolderId() {
        return this.holderId;
    }

    @Override
    public void setHolderId(String holderId) {
        this.holderId = holderId;
    }

    @Override
    public Integer getPermission() {
        return this.permission;
    }

    @Override
    public void setPermission(Integer permission) {
        this.permission = permission;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public static RestPermission createPluginFullEditorGroupPermission(String groupName) {
        return RestPermission.createPluginGroupPermission(groupName, "user");
    }

    public static RestPermission createPluginLabsAccessGroupPermission(String groupName) {
        return RestPermission.createPluginGroupPermission(groupName, "labs");
    }

    public static RestPermission createTeamManagementAccessGroupPermission(String groupName) {
        return RestPermission.createPluginGroupPermission(groupName, "team-mgmt");
    }

    public static RestPermission createPluginFullEditorUserPermission(String userId) {
        return RestPermission.createPluginUserPermission(userId, "user");
    }

    public static RestPermission createPlanEditorUserPermission(String planId, String userId) {
        return RestPermission.createPlanUserPermission(planId, userId, IPermission.PERMISSION_EDITOR);
    }

    public static RestPermission createPlanViewerUserPermission(String planId, String userId) {
        return RestPermission.createPlanUserPermission(planId, userId, IPermission.PERMISSION_VIEWER);
    }

    private static RestPermission createPlanUserPermission(String planId, String userId, Integer permissionKey) {
        RestPermission permission = new RestPermission();
        permission.setTargetType("plan");
        permission.setPermission(permissionKey);
        permission.setHolderType("user");
        permission.setTargetId(planId);
        permission.setHolderId(userId);
        return permission;
    }

    private static RestPermission createPluginGroupPermission(String groupName, String targetId) {
        RestPermission permission = new RestPermission();
        permission.setTargetType("system");
        permission.setTargetId(targetId);
        permission.setHolderType("group");
        permission.setHolderId(groupName);
        permission.setPermission(IPermission.PERMISSION_EDITOR);
        return permission;
    }

    private static RestPermission createPluginUserPermission(String userId, String targetId) {
        RestPermission permission = new RestPermission();
        permission.setTargetType("system");
        permission.setTargetId(targetId);
        permission.setHolderType("user");
        permission.setHolderId(userId);
        permission.setPermission(IPermission.PERMISSION_EDITOR);
        return permission;
    }
}

