/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.ApacheLpAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.WeightedAssignmentLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidateSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidateSolutionImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentSolutionCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.ImmutableWeightedAssignmentLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.WeightedAssignmentLpProblemCreator;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.search.InterruptableFunction;
import com.google.common.base.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
class SearchCandidateTransformation
implements InterruptableFunction<AssignmentCandidate, AssignmentCandidateSolution> {
    private static final Log LOGGER = Log.with(SearchCandidateTransformation.class);
    private final LpAssignmentSolver lpSolver;
    private final WeightedAssignmentLpProblemCreator lpProblemCreator;
    private final AssignmentSolutionCreator solutionCreator;

    SearchCandidateTransformation(CancellationState cancellationState) {
        this(new ApacheLpAssignmentSolver(cancellationState), new WeightedAssignmentLpProblemCreator(), new AssignmentSolutionCreator());
    }

    SearchCandidateTransformation(LpAssignmentSolver lpSolver, WeightedAssignmentLpProblemCreator lpProblemCreator, AssignmentSolutionCreator solutionCreator) {
        this.lpSolver = lpSolver;
        this.lpProblemCreator = lpProblemCreator;
        this.solutionCreator = solutionCreator;
    }

    @Override
    public AssignmentCandidateSolution apply(AssignmentCandidate input) throws InterruptedException {
        LogUtil.debug(LOGGER, "create solution for: %s", input);
        Optional<ImmutableWeightedAssignmentLpProblem> lpProblem = this.lpProblemCreator.tryCreate(input);
        if (!lpProblem.isPresent()) {
            LogUtil.debug(LOGGER, "no valid LP created");
            return null;
        }
        Optional<LpSolution> solution = this.lpSolver.trySolve((WeightedAssignmentLpProblem)lpProblem.get());
        if (!solution.isPresent()) {
            LogUtil.debug(LOGGER, "LP has not solution");
            return null;
        }
        AssignmentCandidateSolutionImpl assignmentSolution = this.solutionCreator.createInstance((LpSolution)solution.get(), input);
        LogUtil.debug(LOGGER, "created solution: %s", assignmentSolution);
        return assignmentSolution;
    }
}

