/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.CorruptIndexException;
import com.atlassian.rm.common.bridges.lucene.Document;
import com.atlassian.rm.common.bridges.lucene.Document73;
import com.atlassian.rm.common.bridges.lucene.IndexReader;
import com.atlassian.rm.common.bridges.lucene.IndexSearcher;
import com.atlassian.rm.common.bridges.lucene.IndexSearcher73;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;

public class IndexReader73
implements IndexReader {
    private final org.apache.lucene.index.IndexReader indexReader;

    public IndexReader73(org.apache.lucene.index.IndexReader indexReader) {
        this.indexReader = indexReader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexReader73 that = (IndexReader73)o;
        return this.indexReader.equals((Object)that.indexReader);
    }

    public int hashCode() {
        return this.indexReader.hashCode();
    }

    org.apache.lucene.index.IndexReader getLuceneValue() {
        return this.indexReader;
    }

    @Override
    public Document getDocument(int position) throws IOException {
        try {
            return new Document73(this.indexReader.document(position));
        }
        catch (org.apache.lucene.index.CorruptIndexException e) {
            throw new CorruptIndexException((Exception)((Object)e));
        }
    }

    @Override
    public Document getDocument(int position, List<String> fieldNames) throws IOException {
        try {
            return new Document73(this.indexReader.document(position, (Set)Sets.newHashSet(fieldNames)));
        }
        catch (org.apache.lucene.index.CorruptIndexException e) {
            throw new CorruptIndexException((Exception)((Object)e));
        }
    }

    @Override
    public IndexSearcher openSearcher() {
        return new IndexSearcher73(new org.apache.lucene.search.IndexSearcher(this.indexReader));
    }

    @Override
    public void extractAllReaders(Collection<IndexReader> collection) {
        for (LeafReaderContext context : this.indexReader.leaves()) {
            collection.add(new IndexReader73((org.apache.lucene.index.IndexReader)context.reader()));
        }
    }

    @Override
    public IndexReader extractSubReaderForDoc(int doc) {
        return new IndexReader73((org.apache.lucene.index.IndexReader)((LeafReaderContext)this.indexReader.leaves().get(ReaderUtil.subIndex((int)doc, (List)this.indexReader.leaves()))).reader());
    }

    @Override
    public boolean isClosed() {
        return this.indexReader.getRefCount() <= 0;
    }

    @Override
    public void close() throws IOException {
        try {
            this.indexReader.close();
        }
        catch (org.apache.lucene.index.CorruptIndexException e) {
            throw new CorruptIndexException((Exception)((Object)e));
        }
    }
}

