/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IBacklogState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotsAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.EpisodeScheduleSelector;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.FixedSprintSolutionTransformer;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.TransformedActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.TransformedUnstructuredSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.EpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivitySet;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IUnstructuredItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ProcessingItemType;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class FixedSprintSolutionTransformerImpl
implements FixedSprintSolutionTransformer {
    private final EpisodeScheduleSelector episodeAssignmentCreator = new EpisodeScheduleSelector();

    @Override
    public LinkedHashSet<IEpisodeSchedule> addFixedSlotResults(FixedSlotsAssignmentSolution fixedSolution, LinkedHashSet<IEpisodeSchedule> episodeSchedules, IBacklogState backlogState) {
        LinkedHashSet transformed = Sets.newLinkedHashSetWithExpectedSize((int)episodeSchedules.size());
        Map<IEpisodeSchedule, Set<IProcessingItem>> distribution = this.getEpisodeAssignment(fixedSolution, episodeSchedules, backlogState);
        for (IEpisodeSchedule originalSchedule : Sets.union(episodeSchedules, distribution.keySet())) {
            transformed.add(EpisodeSchedule.createInstance(originalSchedule.getEpisode(), (Set<IActivitySetSchedule>)Sets.union(originalSchedule.getActivitySetSchedules(), this.transformActivitySetSchedules(distribution.get(originalSchedule), fixedSolution, originalSchedule)), (Set<IUnstructuredItemSchedule>)Sets.union(originalSchedule.getUnstructuredItemSchedules(), this.transformUnstructured(distribution.get(originalSchedule), fixedSolution, originalSchedule)), originalSchedule.getReleaseTime()));
        }
        return transformed;
    }

    private Map<IEpisodeSchedule, Set<IProcessingItem>> getEpisodeAssignment(FixedSlotsAssignmentSolution fixedSolution, LinkedHashSet<IEpisodeSchedule> episodeSchedules, IBacklogState backlogState) {
        BiMap<String, IEpisodeSchedule> scheduleMap = RmIdentifiableUtils.createIdMap(episodeSchedules);
        HashMap distribution = Maps.newHashMap();
        for (IProcessingItem item : fixedSolution.getProcessingItems()) {
            IEpisodeSchedule scheduleToAdd = this.episodeAssignmentCreator.getScheduleToAdd(fixedSolution.getInterval(item.getId()), backlogState.getPossibleEpisodesForItem(item.getId()), scheduleMap);
            if (!scheduleMap.containsKey((Object)scheduleToAdd.getId())) {
                scheduleMap.put((Object)scheduleToAdd.getId(), (Object)scheduleToAdd);
            }
            RmUtils.addToKeyedSets(distribution, scheduleToAdd, item);
        }
        return distribution;
    }

    private Set<IUnstructuredItemSchedule> transformUnstructured(Set<IProcessingItem> items, FixedSlotsAssignmentSolution fixedSolution, IEpisodeSchedule scheduleToIntegrate) {
        if (items == null) {
            return scheduleToIntegrate.getUnstructuredItemSchedules();
        }
        HashSet transformedSchedules = Sets.newHashSet();
        for (IProcessingItem item : items) {
            if (!item.getProcessingItemType().equals((Object)ProcessingItemType.Unstructured)) continue;
            transformedSchedules.add(TransformedUnstructuredSchedule.create((IUnstructuredItem)item, fixedSolution, scheduleToIntegrate));
        }
        return transformedSchedules;
    }

    private Set<IActivitySetSchedule> transformActivitySetSchedules(Set<IProcessingItem> items, FixedSlotsAssignmentSolution fixedSolution, IEpisodeSchedule scheduleToIntegrate) {
        if (items == null) {
            return scheduleToIntegrate.getActivitySetSchedules();
        }
        HashSet transformedSchedules = Sets.newHashSet();
        for (IProcessingItem item : items) {
            if (!item.getProcessingItemType().equals((Object)ProcessingItemType.ActivitySet)) continue;
            transformedSchedules.add(TransformedActivitySetSchedule.create((IActivitySet)item, fixedSolution, scheduleToIntegrate));
        }
        return transformedSchedules;
    }
}

