/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WorkAssignment
implements IWorkAssignment {
    private final IWorkResource workResource;
    private final IResourceType resourceType;
    private final IWorkSlot workSlot;
    private final float assignedWorkUnits;
    private final IProcessingStage processingStage;
    private final String itemId;
    private final IEpisode episode;
    private final IResourceGroup resourceGroup;

    public WorkAssignment(String itemId, IWorkSlot workSlot, IProcessingStage processingStage, IResourceGroup resourceGroup, IWorkResource workResource, IResourceType resourceType, float assignedWorkUnits, IEpisode episode) {
        Preconditions.checkNotNull((Object)itemId, (Object)"item id must not be null");
        Preconditions.checkNotNull((Object)resourceGroup, (Object)"group must not be null");
        Preconditions.checkNotNull((Object)workResource, (Object)"resource must not be null");
        Preconditions.checkNotNull((Object)resourceType, (Object)"resource type must not be null");
        Preconditions.checkArgument((assignedWorkUnits > 0.0f ? 1 : 0) != 0, (Object)"work assignment must be greater zero");
        Preconditions.checkArgument((boolean)workResource.getResourceTypes().contains(resourceType), (Object)"resource type not available for resource");
        this.itemId = itemId;
        this.resourceGroup = resourceGroup;
        this.workResource = workResource;
        this.processingStage = processingStage;
        this.resourceType = resourceType;
        this.workSlot = workSlot;
        this.assignedWorkUnits = assignedWorkUnits;
        this.episode = episode;
    }

    @Override
    public String getItemId() {
        return this.itemId;
    }

    @Override
    public IResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    @Override
    public IWorkResource getResource() {
        return this.workResource;
    }

    @Override
    public IResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public float getAssignedWorkUnits() {
        return this.assignedWorkUnits;
    }

    @Override
    public IProcessingStage getProcessingStage() {
        return this.processingStage;
    }

    @Override
    public IEpisode getProjectEpisode() {
        return this.episode;
    }

    @Override
    public IWorkSlot getWorkSlot() {
        return this.workSlot;
    }

    @Override
    public int getStart() {
        return this.workSlot.getStart();
    }

    @Override
    public int getEnd() {
        return this.workSlot.getEnd();
    }

    @Override
    public int getLength() {
        return this.workSlot.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.workSlot.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.workSlot.getOverlappingInterval(interval);
    }

    public String toString() {
        return "WorkAssignment [workResource=" + this.workResource + ", resourceType=" + this.resourceType + ", workSlot=" + this.workSlot + ", assignedWorkUnits=" + this.assignedWorkUnits + ", processingStage=" + this.processingStage + "]";
    }
}

