/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.solver;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CalculationState;
import com.atlassian.rm.jpo.scheduling.calculation.NoOpCalculationState;
import com.atlassian.rm.jpo.scheduling.instrumentation.SolverMetrics;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.IRoadmapScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.GreedyRoadmapScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblemDataSource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IRoadmapSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.solver.DefaultSolverConfiguration;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.solver.IRoadmapPlanningProblemSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.solver.SolverConfiguration;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Preconditions;

public class GreedyRoadmapPlanningSolver
implements IRoadmapPlanningProblemSolver {
    private static final Log LOGGER = Log.with(GreedyRoadmapPlanningSolver.class);
    private final IRoadmapScheduler algorithm;

    protected GreedyRoadmapPlanningSolver(IRoadmapScheduler algorithm) {
        Preconditions.checkNotNull((Object)algorithm, (Object)"solver algorithm must not be null");
        this.algorithm = algorithm;
    }

    @Override
    public IRoadmapSchedule solveRoadmapPlanningProblem(IRoadmapProblemDataSource dataSource) throws InterruptedException {
        Preconditions.checkNotNull((Object)dataSource, (Object)"problem data source must not be null");
        LogUtil.debug(LOGGER, "solve roadmap planning problem from data source: %s", dataSource);
        IRoadmapProblem problem = dataSource.getRoadmapProblem();
        IRoadmapSchedule schedule = this.algorithm.schedule(problem);
        LogUtil.debug(LOGGER, "created solution: %s", schedule);
        return schedule;
    }

    @Deprecated
    public static GreedyRoadmapPlanningSolver createInstance(SolverConfiguration solverConfiguration, CalculationState calculationState) {
        return GreedyRoadmapPlanningSolver.createInstance(solverConfiguration, calculationState, new SolverMetrics());
    }

    public static GreedyRoadmapPlanningSolver createInstance(SolverConfiguration solverConfiguration, CalculationState calculationState, SolverMetrics metrics) {
        GreedyRoadmapScheduler algorithm = GreedyRoadmapScheduler.createInstance(solverConfiguration, calculationState, metrics);
        GreedyRoadmapPlanningSolver instance = new GreedyRoadmapPlanningSolver(algorithm);
        return instance;
    }

    public static GreedyRoadmapPlanningSolver createInstance() {
        return GreedyRoadmapPlanningSolver.createInstance(new DefaultSolverConfiguration(), new NoOpCalculationState(), new SolverMetrics());
    }
}

