/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.ImmutableList;
import com.mysema.query.sql.WindowFunction;
import com.mysema.query.sql.WindowOver;
import com.mysema.query.types.Expression;
import com.mysema.query.types.MutableExpressionBase;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.TemplateFactory;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.ComparableExpressionBase;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.template.SimpleTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WindowFirstLast<T>
extends MutableExpressionBase<T> {
    private static final long serialVersionUID = 4107262569593794721L;
    private static final String ORDER_BY = "order by ";
    private final List<OrderSpecifier<?>> orderBy = new ArrayList();
    private volatile SimpleExpression<T> value;
    private final Expression<T> target;
    private final boolean first;

    public WindowFirstLast(WindowOver<T> target, boolean first) {
        super(target.getType());
        this.target = target;
        this.first = first;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return this.getValue().accept(v, context);
    }

    public WindowFirstLast<T> orderBy(ComparableExpressionBase<?> orderBy) {
        this.value = null;
        this.orderBy.add(orderBy.asc());
        return this;
    }

    public WindowFirstLast<T> orderBy(ComparableExpressionBase<?> ... orderBy) {
        this.value = null;
        for (ComparableExpressionBase<?> e : orderBy) {
            this.orderBy.add(e.asc());
        }
        return this;
    }

    public WindowFirstLast<T> orderBy(OrderSpecifier<?> orderBy) {
        this.value = null;
        this.orderBy.add(orderBy);
        return this;
    }

    public WindowFirstLast<T> orderBy(OrderSpecifier<?> ... orderBy) {
        this.value = null;
        this.orderBy.addAll(Arrays.asList(orderBy));
        return this;
    }

    SimpleExpression<T> getValue() {
        if (this.value == null) {
            if (this.orderBy.isEmpty()) {
                throw new IllegalStateException("No order by arguments given");
            }
            ImmutableList.Builder args = ImmutableList.builder();
            StringBuilder builder = new StringBuilder();
            builder.append("{0} keep (dense_rank ");
            args.add(this.target);
            builder.append(this.first ? "first " : "last ");
            builder.append(ORDER_BY);
            boolean first = true;
            int size = 1;
            for (OrderSpecifier<?> expr : this.orderBy) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("{" + size + "}");
                if (!expr.isAscending()) {
                    builder.append(" desc");
                }
                args.add(expr.getTarget());
                ++size;
                first = false;
            }
            builder.append(")");
            this.value = new SimpleTemplate<T>(this.target.getType(), TemplateFactory.DEFAULT.create(builder.toString()), args.build());
        }
        return this.value;
    }

    public WindowFunction<T> over() {
        return new WindowFunction<T>(this.getValue());
    }
}

