/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.backlog;

import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.generator.backlog.IDependencyConfiguration;
import java.util.Map;
import java.util.Set;

public class DependencyConfiguration
implements IDependencyConfiguration {
    private final Map<String, Set<String>> titleToPrerequisisteTitles;

    public DependencyConfiguration(Map<String, Set<String>> titleToPrerequisisteTitles) {
        this.titleToPrerequisisteTitles = titleToPrerequisisteTitles;
    }

    @Override
    public Map<String, Set<String>> getTitleToPrerequisiteTitles() {
        return this.titleToPrerequisisteTitles;
    }

    public static class Builder {
        private Map<String, Set<String>> titleToPrerequisisteTitles = Maps.newHashMap();

        public Builder add(String dependentTitle, String prerequisiteTitle) {
            RmUtils.addToKeyedSets(this.titleToPrerequisisteTitles, dependentTitle, prerequisiteTitle);
            return this;
        }

        public DependencyConfiguration build() {
            return new DependencyConfiguration(this.titleToPrerequisisteTitles);
        }
    }
}

