/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.sql;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.AOStreamToTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StreamToTeamSql
extends BaseAOPersistenceSQL {
    private static final Log LOGGER = Log.with(StreamToTeamSql.class);
    private final PersistenceIndex persistenceIndex;

    public StreamToTeamSql(PersistenceIndex persistenceIndex, ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.persistenceIndex = persistenceIndex;
    }

    public void setTeamAssignment(String streamId, Set<String> teamIds) throws SQLException {
        PortfolioStreamPersistence streamPersistence = this.persistenceIndex.getBeanFromContext(PortfolioStreamPersistence.class);
        PortfolioTeamPersistence teamPersistence = this.persistenceIndex.getBeanFromContext(PortfolioTeamPersistence.class);
        LOGGER.debug("set team assignment for stream %s", streamId);
        if (!streamPersistence.exists(streamId)) {
            LOGGER.debug("stream does not exist: %s", streamId);
            return;
        }
        for (String teamId : teamIds) {
            if (!teamPersistence.exists(teamId)) {
                LOGGER.debug("team does not exist: %s", teamId);
                continue;
            }
            this.insertAssignment(streamId, teamId);
        }
        LOGGER.debug("team assignment updated", new Object[0]);
    }

    private void insertAssignment(final String streamId, final String teamId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOStreamToTeam.class, "t").insert().tableNoAlias("t").raw("(").colNoAlias("t", "aoStream").raw(",").colNoAlias("t", "aoTeam").raw(") VALUES (").numeric(streamId).raw(",").numeric(teamId).raw(")");
            }
        });
    }

    public void clearStreamAssignmentsForTeam(final String teamId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOStreamToTeam.class, "t").deleteFrom().tableNoAlias("t").where().colNoAlias("t", "aoTeam").eq().numeric(teamId);
            }
        });
    }

    public void clearTeamAssignmentsForStream(final String streamId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOStreamToTeam.class, "t").deleteFrom().tableNoAlias("t").where().colNoAlias("t", "aoStream").eq().numeric(streamId);
            }
        });
    }

    public Set<String> getRestrictedTeamIds(final String streamId) throws SQLException {
        return this.sql(new IQuery<Set<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOStreamToTeam.class, "t").select().col("t", "aoTeam").from("t").where().col("t", "aoStream").eq().numeric(streamId);
            }

            @Override
            public Set<String> handleResult(ResultSet result) throws Exception {
                HashSet retVal = Sets.newHashSet();
                while (result.next()) {
                    String team = BaseAOPersistenceSQL.getString(result, 1);
                    retVal.add(team);
                }
                return retVal;
            }
        });
    }

    public boolean validateAssignment(final List<String> teamIds) throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOTeam.class, "t").select().raw("COUNT(*)").from("t").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colId("t");
                    }
                }, teamIds);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                if (result.next() && BaseAOPersistenceSQL.getInt(result, 1) == 0) {
                    return true;
                }
                return false;
            }
        });
    }
}

