/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port.dynamics.handlers;

import com.radiantminds.roadmap.common.data.persistence.ao.port.dynamics.DynamicValueHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.stereotype.Component;

@Component
public class DynamicDateHandler
implements DynamicValueHandler {
    private static final Pattern PATTERN = Pattern.compile("\\$DATE(START|END)?(\\(([+-])?(\\d*)?\\))?");

    @Override
    public Pattern getMatchPattern() {
        return PATTERN;
    }

    @Override
    public String getReplacement(Matcher matcher) {
        String todString = matcher.group(1);
        long todModifier = 0L;
        if (todString != null && "END".equals(todString)) {
            todModifier = 86399999L;
        }
        String sign = matcher.group(3);
        long signFactor = 1L;
        if (sign != null && "-".equals(sign)) {
            signFactor = -1L;
        }
        String offsetString = matcher.group(4);
        long offset = 0L;
        if (offsetString != null && offsetString.length() > 0) {
            offset = Long.parseLong(offsetString);
        }
        long todayStart = new DateTime(System.currentTimeMillis(), DateTimeZone.UTC).withMillisOfDay(0).getMillis();
        long nowWithOffset = todayStart + (offset *= signFactor) * 1000L * 60L * 60L * 24L;
        return String.valueOf(nowWithOffset += todModifier);
    }
}

