/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.releases.SchedulingRelease;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSolutionInterval;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestStageOrSkillId;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IPlanSolution;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IReleaseStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IResourceTypeDescription;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IScheduleStatistics;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.Interval;

@XmlRootElement(name="release")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestReleaseEntry {
    @XmlElement
    private String id;
    @XmlElement
    private Long fixedStart;
    @XmlElement
    private Long fixedEnd;
    @XmlElement
    private Long deltaStartDate;
    @XmlElement
    private Boolean isLater;
    @XmlElement
    private Boolean isEmpty;
    @XmlElement
    private Double utilization;
    @XmlElement
    private Double plannedWorkload;
    @XmlElement
    private Double averageWorkload;
    @XmlElement
    private Double overbookedWork;
    @XmlElement
    private List<RestStageOrSkillId> freeCapacities;
    @XmlElement
    private Double availableWorkload;
    @XmlElement
    private RestSolutionInterval solutionInterval;

    protected RestReleaseEntry() {
    }

    public RestReleaseEntry(String id, Long fixedStart, Long fixedEnd, Long deltaStartDate, Boolean isLater, Boolean isEmpty, IReleaseStatistics stats, RestSolutionInterval solutionInterval) {
        this.id = id;
        this.fixedStart = fixedStart;
        this.fixedEnd = fixedEnd;
        this.deltaStartDate = deltaStartDate;
        this.isLater = isLater;
        this.isEmpty = isEmpty;
        this.solutionInterval = solutionInterval;
        if (stats != null) {
            this.utilization = stats.getUtilization();
            this.plannedWorkload = stats.getWorkLoad();
            this.averageWorkload = stats.getAvgResourceUtilization();
            this.overbookedWork = (Double)stats.getOverBookedWork().orNull();
            this.availableWorkload = stats.getAvailableWork();
            this.freeCapacities = Lists.newArrayList();
            for (IResourceTypeDescription desc : stats.getFreeCapacitiesOfResourceTypes()) {
                this.freeCapacities.add(new RestStageOrSkillId(desc.getId(), desc.isGenerated() ? "stage" : "skill"));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public RestSolutionInterval getCalculatedInterval() {
        return this.solutionInterval;
    }

    public static Function<SchedulingRelease, RestReleaseEntry> createFromFunction(final IPlanSolution planSolution) {
        return new Function<SchedulingRelease, RestReleaseEntry>(){

            public RestReleaseEntry apply(SchedulingRelease release) {
                String id = release.getId();
                boolean isEmpty = !RestReleaseEntry.releaseHasAssignedWorkitems(id, planSolution.getPlanStatistics().getReleaseStatistics());
                boolean isLater = release.getIsLaterRelease();
                IReleaseStatistics stats = RestReleaseEntry.getStatisticsForRelease(planSolution, id);
                RestSolutionInterval interval = new RestSolutionInterval(null, (Interval)planSolution.getReleaseInterval(id).orNull());
                return new RestReleaseEntry(id, (Long)release.getFixedStartDate().orNull(), (Long)release.getFixedEndDate().orNull(), (Long)release.getDeltaStartDate().orNull(), isLater ? Boolean.valueOf(true) : null, isEmpty, stats, interval);
            }
        };
    }

    private static boolean releaseHasAssignedWorkitems(final String releaseId, Set<IReleaseStatistics> releaseStatistics) {
        Set statisticsForRelease = Sets.filter(releaseStatistics, (Predicate)new Predicate<IReleaseStatistics>(){

            public boolean apply(@Nullable IReleaseStatistics iReleaseStatistics) {
                return releaseId.equals(iReleaseStatistics.getId());
            }
        });
        boolean hasWorkload = false;
        for (IReleaseStatistics statistics : statisticsForRelease) {
            if (!(statistics.getWorkLoad() > 0.0)) continue;
            hasWorkload = true;
            break;
        }
        return hasWorkload;
    }

    private static IReleaseStatistics getStatisticsForRelease(IPlanSolution planSolution, String releaseId) {
        IScheduleStatistics stats = planSolution.getPlanStatistics();
        for (IReleaseStatistics releaseStats : stats.getReleaseStatistics()) {
            if (!ObjectUtils.equals(releaseStats.getId(), releaseId)) continue;
            return releaseStats;
        }
        return null;
    }
}

