/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.permissions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.api.PluginPermission;
import com.radiantminds.roadmap.common.data.entities.permissions.IPermission;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.permissions.PlanPermission;
import com.radiantminds.roadmap.common.permissions.PlanPermissionCheckResult;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Nullable;

public class SelfDeletionChecker {
    private final PlanPermissions planPermissionHandler;
    private final PluginPermissions pluginPermissionHandler;
    private final UserExtension userExtension;

    public SelfDeletionChecker(PlanPermissions planPermissionHandler, PluginPermissions pluginPermissionHandler, UserExtension userExtension) {
        this.planPermissionHandler = planPermissionHandler;
        this.pluginPermissionHandler = pluginPermissionHandler;
        this.userExtension = userExtension;
    }

    public boolean wouldRemovalLeadToDenied(String planId, final String removedPermissionsId) throws PersistenceException, SQLException {
        List<IPermission> planPermissions = this.planPermissionHandler.getSecuredPermissions(this.userExtension, planId);
        Iterables.removeIf(planPermissions, (Predicate)new Predicate<IPermission>(){

            public boolean apply(@Nullable IPermission permission) {
                return permission.getId().equals(removedPermissionsId);
            }
        });
        return this.checkInternalWouldLeadToDenied(planPermissions);
    }

    public boolean wouldAddLeadToDenied(String planId, IPermission addedPermission) throws PersistenceException, SQLException {
        List<IPermission> planPermissions = this.planPermissionHandler.getSecuredPermissions(this.userExtension, planId);
        planPermissions.add(addedPermission);
        return this.checkInternalWouldLeadToDenied(planPermissions);
    }

    private boolean checkInternalWouldLeadToDenied(List<IPermission> planPermissions) throws SQLException {
        PlanPermissionCheckResult checkResult = this.planPermissionHandler.check(planPermissions, PlanPermission.Editor);
        if (checkResult.isDenied()) {
            return true;
        }
        if (checkResult.needsPluginPermission()) {
            boolean pluginLevelAllowed = this.pluginPermissionHandler.checkOr(PluginPermission.FullEditor, PluginPermission.NonPublishingEditor);
            return !pluginLevelAllowed;
        }
        return false;
    }
}

