/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.solution;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ISchedulingAssignment;
import javax.annotation.concurrent.Immutable;
import org.joda.time.Interval;

@Immutable
class SchedulingAssignment
implements ISchedulingAssignment {
    private final IWorkAssignment workAssignment;
    private final Interval workInterval;

    public SchedulingAssignment(IWorkAssignment workAssignment, Interval workInterval) {
        this.workAssignment = workAssignment;
        this.workInterval = workInterval;
    }

    @Override
    public String getResourceId() {
        return this.workAssignment.getResource().getId();
    }

    @Override
    public String getWorkItemId() {
        return this.workAssignment.getItemId();
    }

    @Override
    public String getSkillId() {
        return this.workAssignment.getResourceType().getId();
    }

    @Override
    public String getReleaseId() {
        return this.workAssignment.getProjectEpisode().getId();
    }

    @Override
    public double getWorkLoad() {
        return this.workAssignment.getAssignedWorkUnits();
    }

    @Override
    public String getStreamId() {
        return this.workAssignment.getProjectEpisode().getStreamId();
    }

    @Override
    public String getStageId() {
        return this.workAssignment.getProcessingStage().getId();
    }

    @Override
    public String getTeamId() {
        return this.workAssignment.getResourceGroup().getId();
    }

    @Override
    public Interval getWorkInterval() {
        return this.workInterval;
    }

    @Override
    public int getSprintIndex() {
        return this.workAssignment.getWorkSlot().getIndex();
    }
}

