/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.point;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.LinearTeamVelocityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ResourceGroupFactory;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TeamVelocitySupplyWrapper;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.Resource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositiveTroveMap;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.IResourceTypeMapping;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.ScrumSprintTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.point.BasePointTeamTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.point.LinearTeamVelocityFunctionFactory;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class EmptyPointsTeamTransformer
extends BasePointTeamTransformer {
    private static final Log LOGGER = Log.with(EmptyPointsTeamTransformer.class);
    static final String SORT_KEY = "0";
    private final TimeStepPresenceFunction timeStepPresenceFunction;

    public EmptyPointsTeamTransformer(ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        super(timeTransformer, timeStepPresenceFunction);
        this.timeStepPresenceFunction = timeStepPresenceFunction;
    }

    EmptyPointsTeamTransformer(ScrumSprintTransformer sprintTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        super(sprintTransformer);
        this.timeStepPresenceFunction = timeStepPresenceFunction;
    }

    public IResourceGroup createEmptyTeam(SchedulingTeam team, IResourceTypeMapping resourceTypeMapping, SchedulingConfig planConfiguration) {
        LOGGER.debug("create team resource for team: %s", team);
        WorkSlotsDefinition slotDefinition = this.sprintTransformer.createWorkSlotDefinition(team, planConfiguration.getGlobalSprintLength());
        float velocity = this.getVelocity(team, planConfiguration.getGlobalDefaultVelocity());
        LinearTeamVelocityFunction teamVelocity = LinearTeamVelocityFunctionFactory.createInstance(team, velocity, slotDefinition, this.timeStepPresenceFunction);
        TeamVelocitySupplyWrapper supplyFunction = new TeamVelocitySupplyWrapper(teamVelocity, slotDefinition);
        ImmutableNonEmptyPositivePrimitivesMap<IResourceType> skillMap = this.createFullMap((Set<IResourceType>)Sets.union((Set)resourceTypeMapping.getStageTypeMapping().values(), (Set)resourceTypeMapping.getSkillTypeMapping().values()));
        Resource teamResource = new Resource("team-resource-" + team.getId(), team.getId(), skillMap, supplyFunction, null, SORT_KEY);
        ResourceGroup group = ResourceGroupFactory.createResourceGroup(team.getId(), Sets.newHashSet((Object[])new IWorkResource[]{teamResource}), slotDefinition, null, team.getSortOrder().toString(), (Boolean)Optional.fromNullable((Object)planConfiguration.getStrictStageDivision()).or((Object)true));
        LOGGER.debug("created resource group: %s", group);
        return group;
    }

    private ImmutableNonEmptyPositivePrimitivesMap<IResourceType> createFullMap(Set<IResourceType> realTypes) {
        HashMap map = Maps.newHashMap();
        if (realTypes.isEmpty()) {
            map.put(ResourceType.DUMMY_TYPE, Float.valueOf(1.0f));
        }
        for (IResourceType type : realTypes) {
            map.put(type, Float.valueOf(1.0f));
        }
        return (ImmutableNonEmptyPositivePrimitivesMap)ImmutableNonEmptyPositiveTroveMap.tryCreate(map).get();
    }
}

