/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.issues.sync.tasks;

import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueData;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueRequest;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimate;
import com.radiantminds.roadmap.common.utils.estimate.EstimateConversionUtil;
import com.radiantminds.roadmap.common.utils.estimate.EstimateUtil;
import com.radiantminds.roadmap.jira.common.components.issues.sync.tasks.BaseEstimationSyncTask;
import java.util.List;
import java.util.Map;

public class TimeEstimateSyncTask
extends BaseEstimationSyncTask {
    private static final Log LOGGER = Log.with(TimeEstimateSyncTask.class);
    private final PortfolioEstimatePersistence estimatePersistence;
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final Map<EstimateUtil.EstimateType, Double> estimates;
    private final String planningUnit;
    private final double hoursPerDay;
    private final Optional<Integer> stageId;
    private final List<IExtensionLink> stageLinks;

    public TimeEstimateSyncTask(PortfolioEstimatePersistence estimatePersistence, PortfolioWorkItemPersistence workItemPersistence, WorkItemExtension workItemExtension, Map<EstimateUtil.EstimateType, Double> estimates, String planningUnit, double hoursPerDay, Optional<Integer> stageId, List<IExtensionLink> stageLinks) {
        super(estimatePersistence, workItemExtension, stageId, IIssueRequest.EstimationMethod.ESTIMATES);
        this.estimatePersistence = estimatePersistence;
        this.workItemPersistence = workItemPersistence;
        this.estimates = estimates;
        this.planningUnit = planningUnit;
        this.hoursPerDay = hoursPerDay;
        this.stageId = stageId;
        this.stageLinks = stageLinks;
    }

    @Override
    public boolean apply(MutableIssue issue, IssueInputParameters issueInputParameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean apply(IWorkItem workItem) {
        try {
            if (workItem.isInitiative()) {
                return false;
            }
            if (this.workItemPersistence.countChildren(workItem.getId()) > 0) {
                return false;
            }
            if (!this.estimates.containsKey((Object)EstimateUtil.EstimateType.ORIGINAL)) {
                return false;
            }
            DataMode syncDataMode = this.getSyncDataMode(workItem.getId());
            Double estimate = this.estimates.get((Object)EstimateUtil.EstimateType.ORIGINAL);
            if (this.stageId.isPresent()) {
                Optional<IEstimate> stageEstimate = this.getCurrentStageEstimate(workItem.getId(), syncDataMode);
                if (stageEstimate.isPresent() && Objects.equal((Object)((IEstimate)stageEstimate.get()).getEstimate(), (Object)estimate)) {
                    return false;
                }
                this.handleStageSync(workItem, estimate, syncDataMode);
                return true;
            }
            Optional<IEstimate> currentEstimate = this.estimatePersistence.getTotalEstimate(workItem.getId(), syncDataMode);
            if (currentEstimate.isPresent() && Objects.equal((Object)((IEstimate)currentEstimate.get()).getEstimate(), (Object)estimate)) {
                return false;
            }
            this.estimatePersistence.setTotalEstimate(workItem.getId(), new RestEstimate(estimate), syncDataMode);
            return true;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to sync time-based estimates for work item %s.", workItem.getId());
            LOGGER.exception(ex);
            return false;
        }
    }

    private void handleStageSync(IWorkItem workItem, Double estimate, DataMode syncDataMode) throws Exception {
        if (this.hasTotalEstimate(workItem.getId(), syncDataMode)) {
            Map<String, IIssueData> stageData = this.getStageDataFromJira(this.stageLinks);
            double coefficient = EstimateConversionUtil.getCoefficient(PlanningUnit.from(this.planningUnit), this.hoursPerDay);
            for (String stageId : stageData.keySet()) {
                Double est = (double)stageData.get(stageId).getEstimate().longValue() * coefficient;
                this.estimatePersistence.setStageEstimate(workItem.getId(), stageId, new RestEstimate(est), syncDataMode);
            }
        }
        this.estimatePersistence.setStageEstimate(workItem.getId(), String.valueOf(this.stageId.get()), new RestEstimate(estimate), syncDataMode);
    }

    public DataMode getSyncDataMode(String workItemId) throws Exception {
        if (this.estimatePersistence.hasOriginalEstimates(workItemId)) {
            return DataMode.Original;
        }
        return DataMode.Default;
    }
}

